/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.theme;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.theme.model.Theme;
import io.gravitee.apim.core.theme.model.ThemeSearchCriteria;
import io.gravitee.apim.core.theme.query_service.ThemeQueryService;
import io.gravitee.apim.infra.adapter.ThemeAdapter;
import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ThemeRepository;
import io.gravitee.repository.management.api.search.ThemeCriteria;
import io.gravitee.repository.management.model.ThemeType;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.service.impl.AbstractService;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ThemeQueryServiceImpl
extends AbstractService
implements ThemeQueryService {
    private final ThemeRepository themeRepository;

    public ThemeQueryServiceImpl(@Lazy ThemeRepository themeRepository) {
        this.themeRepository = themeRepository;
    }

    @Override
    public Page<Theme> searchByCriteria(ThemeSearchCriteria criteria, Pageable pageable) {
        ThemeType type = criteria.getType() == null ? null : ThemeType.valueOf((String)criteria.getType().name());
        try {
            Page page = this.themeRepository.search(ThemeCriteria.builder().enabled(criteria.getEnabled()).type(type).build(), ThemeQueryServiceImpl.convert(pageable));
            return new Page(ThemeAdapter.INSTANCE.map(page.getContent()), page.getPageNumber(), (int)page.getPageElements(), page.getTotalElements());
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException(e.getMessage(), e);
        }
    }
}

