/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.converter.oai;

import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariable;
import io.swagger.v3.oas.models.servers.ServerVariables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.util.CollectionUtils;

public class OAIServersConverter {
    public static OAIServersConverter INSTANCE = new OAIServersConverter();

    public List<String> convert(List<Server> servers) {
        if (servers == null || servers.isEmpty()) {
            return Collections.emptyList();
        }
        return servers.stream().flatMap(server -> {
            ServerVariables serverVariables = server.getVariables();
            String serverUrl = server.getUrl();
            if (CollectionUtils.isEmpty((Map)serverVariables)) {
                return Stream.of(serverUrl);
            }
            List<String> evaluatedUrls = Collections.singletonList(serverUrl);
            for (Map.Entry serverVar : serverVariables.entrySet()) {
                evaluatedUrls = this.evaluateServerUrlsForOneVar((String)serverVar.getKey(), (ServerVariable)serverVar.getValue(), evaluatedUrls);
            }
            return evaluatedUrls.stream();
        }).collect(Collectors.toList());
    }

    private List<String> evaluateServerUrlsForOneVar(String varName, ServerVariable serverVar, List<String> templateUrls) {
        if (varName == null || serverVar == null || CollectionUtils.isEmpty(templateUrls)) {
            return Collections.emptyList();
        }
        return templateUrls.stream().flatMap(templateUrl -> {
            Matcher matcher = Pattern.compile("\\{" + varName + "\\}").matcher((CharSequence)templateUrl);
            if (matcher.find()) {
                if (CollectionUtils.isEmpty((Collection)serverVar.getEnum()) && serverVar.getDefault() != null) {
                    return Stream.of(templateUrl.replace(matcher.group(0), serverVar.getDefault()));
                }
                return serverVar.getEnum().stream().map(enumValue -> templateUrl.replace(matcher.group(0), (CharSequence)enumValue));
            }
            return Stream.of(templateUrl);
        }).collect(Collectors.toList());
    }
}

