/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.integration.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.exception.NotAllowedDomainException;
import io.gravitee.apim.core.integration.crud_service.IntegrationCrudService;
import io.gravitee.apim.core.integration.exception.IntegrationNotFoundException;
import io.gravitee.apim.core.integration.model.Integration;
import io.gravitee.apim.core.license.domain_service.LicenseDomainService;
import lombok.Generated;

@UseCase
public class GetIntegrationUseCase {
    private final IntegrationCrudService integrationCrudService;
    private final LicenseDomainService licenseDomainService;

    public GetIntegrationUseCase(IntegrationCrudService integrationCrudService, LicenseDomainService licenseDomainService) {
        this.integrationCrudService = integrationCrudService;
        this.licenseDomainService = licenseDomainService;
    }

    public Output execute(Input input) {
        String integrationId = input.integrationId();
        if (!this.licenseDomainService.isFederationFeatureAllowed(input.organizationId())) {
            throw NotAllowedDomainException.noLicenseForFederation();
        }
        Integration integrationCreated = this.integrationCrudService.findById(integrationId).orElseThrow(() -> new IntegrationNotFoundException(integrationId));
        return new Output(integrationCreated);
    }

    public record Input(String integrationId, String organizationId) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private String integrationId;
            @Generated
            private String organizationId;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder integrationId(String integrationId) {
                this.integrationId = integrationId;
                return this;
            }

            @Generated
            public InputBuilder organizationId(String organizationId) {
                this.organizationId = organizationId;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.integrationId, this.organizationId);
            }

            @Generated
            public String toString() {
                return "GetIntegrationUseCase.Input.InputBuilder(integrationId=" + this.integrationId + ", organizationId=" + this.organizationId + ")";
            }
        }
    }

    public record Output(Integration integration) {
    }
}

