/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.domain_service.ApiIndexerDomainService;
import io.gravitee.apim.core.api.domain_service.CategoryDomainService;
import io.gravitee.apim.core.api.domain_service.ValidateFederatedApiDomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.event.ApiAuditEvent;
import io.gravitee.apim.core.membership.domain_service.ApiPrimaryOwnerDomainService;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.core.search.Indexer;
import io.gravitee.common.utils.TimeProvider;
import java.util.Collections;
import lombok.Generated;

@UseCase
public class UpdateFederatedApiUseCase {
    private final ApiCrudService apiCrudService;
    private final ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService;
    private final ValidateFederatedApiDomainService validateFederatedApiDomainService;
    private final AuditDomainService auditService;
    private final ApiIndexerDomainService apiIndexerDomainService;
    private final CategoryDomainService categoryDomainService;

    public Output execute(Input input) {
        Api updateApi = input.apiToUpdate;
        AuditInfo auditInfo = input.auditInfo;
        Api currentApi = this.apiCrudService.get(updateApi.getId());
        PrimaryOwnerEntity primaryOwnerEntity = this.apiPrimaryOwnerDomainService.getApiPrimaryOwner(auditInfo.organizationId(), updateApi.getId());
        Api preparedApi = this.validateFederatedApiDomainService.validateAndSanitizeForUpdate(updateApi, currentApi, primaryOwnerEntity);
        preparedApi = ((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)currentApi.toBuilder().name(preparedApi.getName())).description(preparedApi.getDescription())).version(preparedApi.getVersion())).apiLifecycleState(preparedApi.getApiLifecycleState())).visibility(preparedApi.getVisibility())).groups(preparedApi.getGroups())).labels(preparedApi.getLabels())).categories(this.categoryDomainService.toCategoryId(preparedApi, currentApi.getEnvironmentId()))).updatedAt(TimeProvider.now())).build();
        this.createAuditLog(auditInfo, preparedApi, currentApi);
        this.createIndex(auditInfo, preparedApi, primaryOwnerEntity);
        Api updated = this.apiCrudService.update(preparedApi);
        this.categoryDomainService.updateOrderCategoriesOfApi(updated.getId(), updated.getCategories());
        updated.setCategories(this.categoryDomainService.toCategoryKey(updated, updated.getEnvironmentId()));
        return new Output(updated, primaryOwnerEntity);
    }

    private void createAuditLog(AuditInfo auditInfo, Api updatedApi, Api currentApi) {
        this.auditService.createApiAuditLog(ApiAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).apiId(updatedApi.getId()).event(ApiAuditEvent.API_UPDATED).actor(auditInfo.actor()).oldValue(currentApi).newValue(updatedApi).createdAt(updatedApi.getUpdatedAt()).properties(Collections.emptyMap()).build());
    }

    private void createIndex(AuditInfo auditInfo, Api updateApi, PrimaryOwnerEntity primaryOwnerEntity) {
        this.apiIndexerDomainService.index(new Indexer.IndexationContext(auditInfo.organizationId(), auditInfo.environmentId()), updateApi, primaryOwnerEntity);
    }

    @Generated
    public UpdateFederatedApiUseCase(ApiCrudService apiCrudService, ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService, ValidateFederatedApiDomainService validateFederatedApiDomainService, AuditDomainService auditService, ApiIndexerDomainService apiIndexerDomainService, CategoryDomainService categoryDomainService) {
        this.apiCrudService = apiCrudService;
        this.apiPrimaryOwnerDomainService = apiPrimaryOwnerDomainService;
        this.validateFederatedApiDomainService = validateFederatedApiDomainService;
        this.auditService = auditService;
        this.apiIndexerDomainService = apiIndexerDomainService;
        this.categoryDomainService = categoryDomainService;
    }

    public record Input(Api apiToUpdate, AuditInfo auditInfo) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private Api apiToUpdate;
            @Generated
            private AuditInfo auditInfo;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder apiToUpdate(Api apiToUpdate) {
                this.apiToUpdate = apiToUpdate;
                return this;
            }

            @Generated
            public InputBuilder auditInfo(AuditInfo auditInfo) {
                this.auditInfo = auditInfo;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.apiToUpdate, this.auditInfo);
            }

            @Generated
            public String toString() {
                return "UpdateFederatedApiUseCase.Input.InputBuilder(apiToUpdate=" + this.apiToUpdate + ", auditInfo=" + this.auditInfo + ")";
            }
        }
    }

    public record Output(Api updatedApi, PrimaryOwnerEntity primaryOwnerEntity) {
    }
}

