/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl.validation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.rest.api.model.TagReferenceType;
import io.gravitee.rest.api.service.TagService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.TagNotAllowedException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.v4.validation.TagsValidationService;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class TagsValidationServiceImpl
extends AbstractService
implements TagsValidationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TagsValidationServiceImpl.class);
    private final TagService tagService;
    private ObjectMapper objectMapper;

    @Autowired
    public TagsValidationServiceImpl(TagService tagService, ObjectMapper objectMapper) {
        this.tagService = tagService;
        this.objectMapper = objectMapper;
    }

    @Override
    public Set<String> validateAndSanitize(ExecutionContext executionContext, Set<String> oldTags, Set<String> newTags) {
        Set<String> userTags;
        Set<String> tags;
        HashSet<String> tagsToUpdate;
        HashSet existingTags = oldTags == null ? new HashSet() : oldTags;
        HashSet<String> hashSet = tagsToUpdate = newTags == null ? new HashSet<String>() : newTags;
        if (existingTags.isEmpty()) {
            tags = tagsToUpdate;
        } else {
            tags = existingTags.stream().filter(tag -> !tagsToUpdate.contains(tag)).collect(Collectors.toSet());
            tags.addAll(tagsToUpdate.stream().filter(tag -> !existingTags.contains(tag)).collect(Collectors.toSet()));
        }
        if (!tags.isEmpty() && !(userTags = this.tagService.findByUser(this.getAuthenticatedUsername(), executionContext.getOrganizationId(), TagReferenceType.ORGANIZATION)).containsAll(tags)) {
            String[] notAllowedTags = (String[])tags.stream().filter(tag -> !userTags.contains(tag)).toArray(String[]::new);
            throw new TagNotAllowedException(notAllowedTags);
        }
        return newTags;
    }

    @Override
    public void validatePlanTagsAgainstApiTags(Set<String> planTags, io.gravitee.repository.management.model.Api api) {
        try {
            Set apiTags = api.getDefinitionVersion() == DefinitionVersion.V4 ? ((Api)this.objectMapper.readValue(api.getDefinition(), Api.class)).getTags() : ((io.gravitee.definition.model.Api)this.objectMapper.readValue(api.getDefinition(), io.gravitee.definition.model.Api.class)).getTags();
            this.validatePlanTagsAgainstApiTags(planTags, apiTags);
        }
        catch (JsonProcessingException e) {
            throw new TechnicalManagementException("An error occurs while trying load api definition", e);
        }
    }

    @Override
    public void validatePlanTagsAgainstApiTags(Set<String> planTags, Set<String> apiTags) {
        if (!(ObjectUtils.isEmpty(planTags) || !ObjectUtils.isEmpty(apiTags) && apiTags.stream().anyMatch(apiTag -> planTags.contains(apiTag)))) {
            log.debug("Plan rejected, tags {} mismatch the tags defined by the API ({})", planTags, apiTags);
            throw new TagNotAllowedException(planTags.toArray(new String[planTags.size()]));
        }
    }
}

