/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.jackson.ser.api;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.service.jackson.ser.api.ApiDefaultSerializer;
import io.gravitee.rest.api.service.jackson.ser.api.ApiSerializer;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class ApiCompositeSerializer
extends ApiSerializer
implements InitializingBean {
    @Autowired
    private ApplicationContext applicationContext;
    private List<ApiSerializer> serializers = new LinkedList<ApiSerializer>();

    public ApiCompositeSerializer() {
        super(ApiEntity.class);
    }

    @Override
    public boolean canHandle(ApiEntity apiEntity) {
        return true;
    }

    @Override
    public void serialize(ApiEntity apiEntity, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        this.serializers.stream().filter(serializer -> serializer.canHandle(apiEntity)).findFirst().orElse(this.serializers.get(0)).serialize(apiEntity, jsonGenerator, serializerProvider);
    }

    @Override
    public ApiSerializer.Version version() {
        return null;
    }

    public void afterPropertiesSet() {
        this.addSerializer(new ApiDefaultSerializer());
    }

    private void addSerializer(ApiSerializer apiSerializer) {
        apiSerializer.setApplicationContext(this.applicationContext);
        this.serializers.add(apiSerializer);
    }

    public void setSerializers(List<ApiSerializer> serializers) {
        this.serializers = serializers;
    }
}

