/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.plan;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.plan.crud_service.PlanCrudService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.infra.adapter.PlanAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PlanRepository;
import io.gravitee.rest.api.service.exceptions.PlanNotFoundException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class PlanCrudServiceImpl
implements PlanCrudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlanCrudServiceImpl.class);
    private final PlanRepository planRepository;

    public PlanCrudServiceImpl(@Lazy PlanRepository planRepository) {
        this.planRepository = planRepository;
    }

    @Override
    public Plan findById(String planId) {
        try {
            log.debug("Find plan by id : {}", (Object)planId);
            return this.planRepository.findById((Object)planId).map(PlanAdapter.INSTANCE::fromRepository).orElseThrow(() -> new PlanNotFoundException(planId));
        }
        catch (TechnicalException ex) {
            throw new TechnicalDomainException(String.format("An error occurs while trying to find a plan by id: %s", planId), ex);
        }
    }

    @Override
    public Plan create(Plan plan) {
        try {
            io.gravitee.repository.management.model.Plan result = (io.gravitee.repository.management.model.Plan)this.planRepository.create((Object)PlanAdapter.INSTANCE.toRepository(plan));
            return PlanAdapter.INSTANCE.fromRepository(result);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException("An error occurs while trying to create the plan: " + plan.getId(), e);
        }
    }

    @Override
    public Plan update(Plan plan) {
        try {
            io.gravitee.repository.management.model.Plan result = (io.gravitee.repository.management.model.Plan)this.planRepository.update((Object)PlanAdapter.INSTANCE.toRepository(plan));
            return PlanAdapter.INSTANCE.fromRepository(result);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException("An error occurs while trying to update the plan: " + plan.getId(), e);
        }
    }

    @Override
    public void delete(String planId) {
        try {
            this.planRepository.delete((Object)planId);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException("An error occurs while trying to delete the plan: " + planId, e);
        }
    }
}

