/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.event.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.event.model.Event;
import io.gravitee.apim.core.event.model.EventWithInitiator;
import io.gravitee.apim.core.event.query_service.EventQueryService;
import io.gravitee.apim.core.user.crud_service.UserCrudService;
import io.gravitee.apim.core.user.model.BaseUserEntity;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import java.util.List;
import java.util.Optional;

@UseCase
public class SearchEventsUseCase {
    private final EventQueryService eventQueryService;
    private final UserCrudService userCrudService;

    public SearchEventsUseCase(EventQueryService eventQueryService, UserCrudService userCrudService) {
        this.eventQueryService = eventQueryService;
        this.userCrudService = userCrudService;
    }

    public Output execute(Input input) {
        EventQueryService.SearchQuery query = input.query;
        Pageable pageable = input.pageable.orElse((Pageable)new PageableImpl(1, 10));
        EventQueryService.SearchResponse result = this.eventQueryService.search(query, pageable);
        return new Output(this.toEventWithInitiator(result.events()), result.total());
    }

    private List<EventWithInitiator> toEventWithInitiator(List<Event> events) {
        return events.stream().map(event -> {
            Optional<BaseUserEntity> initiator = Optional.ofNullable(event.getProperties().get((Object)Event.EventProperties.USER)).map(userId -> this.userCrudService.findBaseUserById((String)userId).orElse(BaseUserEntity.builder().id((String)userId).build()));
            return new EventWithInitiator((Event)event, initiator.orElse(null));
        }).toList();
    }

    public record Input(EventQueryService.SearchQuery query, Optional<Pageable> pageable) {
        public Input(EventQueryService.SearchQuery query) {
            this(query, Optional.empty());
        }

        public Input(EventQueryService.SearchQuery query, Pageable pageable) {
            this(query, Optional.of(pageable));
        }
    }

    public record Output(List<EventWithInitiator> data, long total) {
    }
}

