/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.UserMembership;
import io.gravitee.rest.api.model.UserRoleEntity;
import io.gravitee.rest.api.model.permissions.ApiPermission;
import io.gravitee.rest.api.model.permissions.EnvironmentPermission;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.PermissionService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class PermissionServiceImpl
extends AbstractService
implements PermissionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PermissionServiceImpl.class);
    private static final String ORGANIZATION_ADMIN = RoleScope.ORGANIZATION.name() + ":" + SystemRole.ADMIN.name();
    private static final Map<RoleScope, MembershipReferenceType> ROLE_SCOPE_TO_REFERENCE_TYPE = Map.ofEntries(new Map.Entry[]{Pair.of((Object)RoleScope.API, (Object)MembershipReferenceType.API), Pair.of((Object)RoleScope.APPLICATION, (Object)MembershipReferenceType.APPLICATION), Pair.of((Object)RoleScope.ORGANIZATION, (Object)MembershipReferenceType.ORGANIZATION), Pair.of((Object)RoleScope.ENVIRONMENT, (Object)MembershipReferenceType.ENVIRONMENT), Pair.of((Object)RoleScope.GROUP, (Object)MembershipReferenceType.GROUP)});
    @Autowired
    MembershipService membershipService;
    @Autowired
    RoleService roleService;
    @Autowired
    UserService userService;

    @Override
    public boolean hasPermission(ExecutionContext executionContext, RolePermission permission, String referenceId, RolePermissionAction ... acls) {
        return this.hasPermission(executionContext, this.getAuthenticatedUsername(), permission, referenceId, acls);
    }

    @Override
    public boolean hasPermission(ExecutionContext executionContext, String userId, RolePermission permission, String referenceId, RolePermissionAction ... acls) {
        if (PermissionServiceImpl.isOrganizationAdmin()) {
            LOGGER.debug("User [{}] has full access because of its ORGANIZATION ADMIN role", (Object)userId);
            return true;
        }
        MembershipReferenceType membershipReferenceType = ROLE_SCOPE_TO_REFERENCE_TYPE.get(permission.getScope());
        Map<String, char[]> permissions = this.membershipService.getUserMemberPermissions(executionContext, membershipReferenceType, referenceId, userId);
        return permissions != null && this.roleService.hasPermission(permissions, permission.getPermission(), acls);
    }

    @Override
    public boolean hasManagementRights(ExecutionContext executionContext, String userId) {
        if (PermissionServiceImpl.isOrganizationAdmin()) {
            LOGGER.debug("User [{}] has full access because of its ORGANIZATION ADMIN role", (Object)userId);
            return true;
        }
        UserEntity user = this.userService.findByIdWithRoles(executionContext, userId);
        return this.hasOrganizationManagementRole(user) || this.hasEnvironmentManagementRole(user) || this.hasApiManagementRole(executionContext, user);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isOrganizationAdmin() {
        if (SecurityContextHolder.getContext().getAuthentication() == null) return false;
        if (!SecurityContextHolder.getContext().getAuthentication().getAuthorities().stream().map(GrantedAuthority::getAuthority).anyMatch(ORGANIZATION_ADMIN::equals)) return false;
        return true;
    }

    private boolean hasApiManagementRole(ExecutionContext executionContext, UserEntity user) {
        return this.streamUserApiIds(executionContext, user).flatMap(apiId -> this.streamApiUserPermissions((String)apiId, user)).filter(Predicate.not(this::isApiRatingPermission)).anyMatch(this::isCreateOrUpdateOrDeletePermission);
    }

    private boolean hasEnvironmentManagementRole(UserEntity user) {
        return this.streamUserRolePermissions(user, RoleScope.ENVIRONMENT).filter(Predicate.not(this::isEnvironmentApplicationPermission)).anyMatch(this::isCreateOrUpdateOrDeletePermission);
    }

    private boolean hasOrganizationManagementRole(UserEntity user) {
        return this.streamUserRolePermissions(user, RoleScope.ORGANIZATION).anyMatch(this::isCreateOrUpdateOrDeletePermission);
    }

    private boolean isCreateOrUpdateOrDeletePermission(Map.Entry<String, char[]> permission) {
        String permissionString = new String(permission.getValue());
        return permissionString.contains("C") || permissionString.contains("U") || permissionString.contains("D");
    }

    private boolean isEnvironmentApplicationPermission(Map.Entry<String, char[]> permission) {
        return EnvironmentPermission.valueOf((String)permission.getKey()) == EnvironmentPermission.APPLICATION;
    }

    private boolean isApiRatingPermission(Map.Entry<String, char[]> permission) {
        ApiPermission apiPermission = ApiPermission.valueOf((String)permission.getKey());
        return apiPermission == ApiPermission.RATING || ApiPermission.RATING_ANSWER == apiPermission;
    }

    private Stream<String> streamUserApiIds(ExecutionContext executionContext, UserEntity user) {
        return this.membershipService.findUserMembership(executionContext, MembershipReferenceType.API, user.getId()).stream().map(UserMembership::getReference).distinct();
    }

    private Stream<Map.Entry<String, char[]>> streamUserRolePermissions(UserEntity user, RoleScope scope) {
        return this.streamUserRoles(user).filter(role -> scope == role.getScope()).flatMap(role -> role.getPermissions().entrySet().stream());
    }

    private Stream<UserRoleEntity> streamUserRoles(UserEntity user) {
        return Stream.ofNullable(user.getRoles()).flatMap(Collection::stream);
    }

    private Stream<Map.Entry<String, char[]>> streamApiUserPermissions(String apiId, UserEntity user) {
        return this.membershipService.getRoles(MembershipReferenceType.API, apiId, MembershipMemberType.USER, user.getId()).stream().flatMap(role -> role.getPermissions().entrySet().stream());
    }
}

