/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.adapter;

import io.gravitee.cockpit.api.command.v1.CockpitCommandType;
import io.gravitee.cockpit.api.command.v1.hello.HelloReplyPayload;
import io.gravitee.exchange.api.command.CommandStatus;
import io.gravitee.exchange.api.command.ReplyAdapter;
import io.gravitee.exchange.api.command.hello.HelloReply;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.OrganizationEntity;
import io.gravitee.rest.api.model.UpdateEnvironmentEntity;
import io.gravitee.rest.api.model.UpdateOrganizationEntity;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.InstallationService;
import io.gravitee.rest.api.service.OrganizationService;
import io.reactivex.rxjava3.core.Single;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HelloReplyAdapter
implements ReplyAdapter<io.gravitee.cockpit.api.command.v1.hello.HelloReply, HelloReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HelloReplyAdapter.class);
    private final InstallationService installationService;
    private final EnvironmentService environmentService;
    private final OrganizationService organizationService;

    public String supportType() {
        return CockpitCommandType.HELLO.name();
    }

    public Single<HelloReply> adapt(String targetId, io.gravitee.cockpit.api.command.v1.hello.HelloReply reply) {
        return Single.just((Object)((HelloReplyPayload)reply.getPayload())).map(replyPayload -> {
            if (reply.getCommandStatus() == CommandStatus.SUCCEEDED) {
                Map additionalInformation = this.installationService.getOrInitialize().getAdditionalInformation();
                additionalInformation.put("COCKPIT_INSTALLATION_ID", replyPayload.getInstallationId());
                additionalInformation.put("COCKPIT_INSTALLATION_STATUS", replyPayload.getInstallationStatus());
                this.installationService.setAdditionalInformation(additionalInformation);
                if (replyPayload.getDefaultEnvironmentCockpitId() != null) {
                    this.updateDefaultEnvironmentCockpitId(replyPayload.getDefaultEnvironmentCockpitId());
                }
                if (replyPayload.getDefaultOrganizationCockpitId() != null) {
                    this.updateDefaultOrganizationCockpitId(replyPayload.getDefaultOrganizationCockpitId());
                }
            }
            return new HelloReply(reply.getCommandId(), (io.gravitee.exchange.api.command.hello.HelloReplyPayload)replyPayload);
        });
    }

    private void updateDefaultEnvironmentCockpitId(String defaultEnvironmentCockpitId) {
        EnvironmentEntity defaultEnvironment = this.environmentService.getDefaultOrInitialize();
        UpdateEnvironmentEntity updateEnvironment = new UpdateEnvironmentEntity(defaultEnvironment);
        updateEnvironment.setCockpitId(defaultEnvironmentCockpitId);
        this.environmentService.createOrUpdate(defaultEnvironment.getOrganizationId(), defaultEnvironment.getId(), updateEnvironment);
    }

    private void updateDefaultOrganizationCockpitId(String defaultOrganizationCockpitId) {
        OrganizationEntity defaultOrganization = this.organizationService.getDefaultOrInitialize();
        UpdateOrganizationEntity updateOrganization = new UpdateOrganizationEntity(defaultOrganization);
        updateOrganization.setCockpitId(defaultOrganizationCockpitId);
        this.organizationService.updateOrganization(defaultOrganization.getId(), updateOrganization);
    }

    @Generated
    public HelloReplyAdapter(InstallationService installationService, EnvironmentService environmentService, OrganizationService organizationService) {
        this.installationService = installationService;
        this.environmentService = environmentService;
        this.organizationService = organizationService;
    }
}

