/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.flow;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.flow.crud_service.FlowCrudService;
import io.gravitee.apim.infra.adapter.FlowAdapter;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.FlowRepository;
import io.gravitee.repository.management.model.flow.FlowReferenceType;
import io.gravitee.rest.api.service.impl.TransactionalService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class FlowCrudServiceImpl
extends TransactionalService
implements FlowCrudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlowCrudServiceImpl.class);
    private final FlowRepository flowRepository;

    public FlowCrudServiceImpl(@Lazy FlowRepository flowRepository) {
        this.flowRepository = flowRepository;
    }

    @Override
    public List<Flow> savePlanFlows(String planId, List<Flow> flows) {
        return this.save(FlowReferenceType.PLAN, planId, flows);
    }

    @Override
    public List<Flow> saveApiFlows(String apiId, List<Flow> flows) {
        return this.save(FlowReferenceType.API, apiId, flows);
    }

    @Override
    public List<Flow> getApiV4Flows(String apiId) {
        return this.getV4(FlowReferenceType.API, apiId);
    }

    @Override
    public List<Flow> getPlanV4Flows(String planId) {
        return this.getV4(FlowReferenceType.PLAN, planId);
    }

    @Override
    public List<io.gravitee.definition.model.flow.Flow> getApiV2Flows(String apiId) {
        return this.getV2(FlowReferenceType.API, apiId);
    }

    @Override
    public List<io.gravitee.definition.model.flow.Flow> getPlanV2Flows(String planId) {
        return this.getV2(FlowReferenceType.PLAN, planId);
    }

    private List<Flow> save(FlowReferenceType flowReferenceType, String referenceId, List<Flow> flows) {
        try {
            log.debug("Save flows for reference {},{}", (Object)flowReferenceType, (Object)flowReferenceType);
            if (flows == null || flows.isEmpty()) {
                this.flowRepository.deleteByReferenceIdAndReferenceType(referenceId, flowReferenceType);
                return List.of();
            }
            Map dbFlowsById = this.flowRepository.findByReference(flowReferenceType, referenceId).stream().collect(Collectors.toMap(io.gravitee.repository.management.model.flow.Flow::getId, Function.identity()));
            Set flowIdsToSave = flows.stream().map(Flow::getId).filter(Objects::nonNull).collect(Collectors.toSet());
            Set flowIdsToDelete = dbFlowsById.keySet().stream().filter(Predicate.not(flowIdsToSave::contains)).collect(Collectors.toSet());
            if (!flowIdsToDelete.isEmpty()) {
                this.flowRepository.deleteAllById(flowIdsToDelete);
            }
            ArrayList<Flow> savedFlows = new ArrayList<Flow>();
            for (int order = 0; order < flows.size(); ++order) {
                Flow flow = flows.get(order);
                io.gravitee.repository.management.model.flow.Flow dbFlow = flow.getId() == null || !dbFlowsById.containsKey(flow.getId()) ? (io.gravitee.repository.management.model.flow.Flow)this.flowRepository.create((Object)FlowAdapter.INSTANCE.toRepository(flow, flowReferenceType, referenceId, order)) : (io.gravitee.repository.management.model.flow.Flow)this.flowRepository.update((Object)FlowAdapter.INSTANCE.toRepositoryUpdate((io.gravitee.repository.management.model.flow.Flow)dbFlowsById.get(flow.getId()), flow, order));
                savedFlows.add(FlowAdapter.INSTANCE.toFlowV4(dbFlow));
            }
            return savedFlows;
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while trying to save flows for " + flowReferenceType + ": " + referenceId;
            log.error(error, (Throwable)ex);
            throw new TechnicalDomainException(error, ex);
        }
    }

    private List<io.gravitee.definition.model.flow.Flow> getV2(FlowReferenceType flowReferenceType, String referenceId) {
        try {
            log.debug("Get flows for reference {},{}", (Object)flowReferenceType, (Object)flowReferenceType);
            return this.flowRepository.findByReference(flowReferenceType, referenceId).stream().sorted(Comparator.comparing(io.gravitee.repository.management.model.flow.Flow::getOrder)).map(FlowAdapter.INSTANCE::toFlowV2).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while trying to get flows for " + flowReferenceType + ": " + referenceId;
            log.error(error, (Throwable)ex);
            throw new TechnicalDomainException(error, ex);
        }
    }

    private List<Flow> getV4(FlowReferenceType flowReferenceType, String referenceId) {
        try {
            log.debug("Get flows for reference {},{}", (Object)flowReferenceType, (Object)flowReferenceType);
            return this.flowRepository.findByReference(flowReferenceType, referenceId).stream().sorted(Comparator.comparing(io.gravitee.repository.management.model.flow.Flow::getOrder)).map(FlowAdapter.INSTANCE::toFlowV4).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while trying to get flows for " + flowReferenceType + ": " + referenceId;
            log.error(error, (Throwable)ex);
            throw new TechnicalDomainException(error, ex);
        }
    }
}

