/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.media.model.Media;
import io.gravitee.apim.infra.adapter.MediaAdapter;
import io.gravitee.rest.api.model.MediaEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MediaAdapterImpl
implements MediaAdapter {
    @Override
    public Media toCoreModel(MediaEntity mediaEntity) {
        if (mediaEntity == null) {
            return null;
        }
        Media.MediaBuilder media = Media.builder();
        media.id(mediaEntity.getId());
        media.hash(mediaEntity.getHash());
        media.type(mediaEntity.getType());
        media.subType(mediaEntity.getSubType());
        media.fileName(mediaEntity.getFileName());
        media.size(mediaEntity.getSize());
        byte[] data = mediaEntity.getData();
        if (data != null) {
            media.data(Arrays.copyOf(data, data.length));
        }
        return media.build();
    }

    @Override
    public List<Media> toCoreModels(List<MediaEntity> mediaEntities) {
        if (mediaEntities == null) {
            return null;
        }
        ArrayList<Media> list = new ArrayList<Media>(mediaEntities.size());
        for (MediaEntity mediaEntity : mediaEntities) {
            list.add(this.toCoreModel(mediaEntity));
        }
        return list;
    }

    @Override
    public MediaEntity toEntity(Media media) {
        byte[] data;
        if (media == null) {
            return null;
        }
        MediaEntity mediaEntity = new MediaEntity();
        mediaEntity.setId(media.getId());
        mediaEntity.setType(media.getType());
        mediaEntity.setSubType(media.getSubType());
        mediaEntity.setFileName(media.getFileName());
        if (media.getSize() != null) {
            mediaEntity.setSize(media.getSize().longValue());
        }
        if ((data = media.getData()) != null) {
            mediaEntity.setData(Arrays.copyOf(data, data.length));
        }
        mediaEntity.setHash(media.getHash());
        return mediaEntity;
    }

    @Override
    public List<MediaEntity> toEntities(List<Media> mediaList) {
        if (mediaList == null) {
            return null;
        }
        ArrayList<MediaEntity> list = new ArrayList<MediaEntity>(mediaList.size());
        for (Media media : mediaList) {
            list.add(this.toEntity(media));
        }
        return list;
    }
}

