/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.integration.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.domain_service.CreateApiDomainService;
import io.gravitee.apim.core.api.domain_service.ValidateFederatedApiDomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.factory.ApiModelFactory;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.documentation.domain_service.CreateApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.exception.NotAllowedDomainException;
import io.gravitee.apim.core.integration.crud_service.IntegrationCrudService;
import io.gravitee.apim.core.integration.exception.IntegrationNotFoundException;
import io.gravitee.apim.core.integration.model.Integration;
import io.gravitee.apim.core.integration.model.IntegrationApi;
import io.gravitee.apim.core.integration.service_provider.IntegrationAgent;
import io.gravitee.apim.core.license.domain_service.LicenseDomainService;
import io.gravitee.apim.core.membership.domain_service.ApiPrimaryOwnerFactory;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.core.plan.domain_service.CreatePlanDomainService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.definition.model.federation.FederatedPlan;
import io.gravitee.definition.model.v4.plan.PlanSecurity;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import io.gravitee.rest.api.model.v4.plan.PlanSecurityType;
import io.gravitee.rest.api.service.common.UuidString;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class IngestIntegrationApisUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IngestIntegrationApisUseCase.class);
    private final IntegrationCrudService integrationCrudService;
    private final ApiPrimaryOwnerFactory apiPrimaryOwnerFactory;
    private final ValidateFederatedApiDomainService validateFederatedApi;
    private final ApiCrudService apiCrudService;
    private final CreateApiDomainService createApiDomainService;
    private final CreatePlanDomainService createPlanDomainService;
    private final IntegrationAgent integrationAgent;
    private final CreateApiDocumentationDomainService createApiDocumentationDomainService;
    private final LicenseDomainService licenseDomainService;

    public Completable execute(Input input) {
        String integrationId = input.integrationId;
        AuditInfo auditInfo = input.auditInfo;
        String organizationId = auditInfo.organizationId();
        String environmentId = auditInfo.environmentId();
        if (!this.licenseDomainService.isFederationFeatureAllowed(organizationId)) {
            return Completable.error((Throwable)NotAllowedDomainException.noLicenseForFederation());
        }
        return Single.fromCallable(() -> this.integrationCrudService.findById(integrationId).filter(integration -> integration.getEnvironmentId().equals(environmentId)).orElseThrow(() -> new IntegrationNotFoundException(integrationId))).flatMapPublisher(integration -> {
            PrimaryOwnerEntity primaryOwner = this.apiPrimaryOwnerFactory.createForNewApi(organizationId, environmentId, input.auditInfo.actor().userId());
            return this.integrationAgent.fetchAllApis((Integration)integration).doOnNext(api -> {
                Api federatedApi = ApiModelFactory.fromIntegration(api, integration);
                if (this.apiCrudService.existsById(federatedApi.getId())) {
                    log.debug("API already ingested [id={}] [name={}]", (Object)api.id(), (Object)api.name());
                    return;
                }
                this.createApi(federatedApi, primaryOwner, auditInfo);
                if (api.plans() != null) {
                    this.createPlans(api.plans(), federatedApi, auditInfo);
                }
                if (api.pages() != null) {
                    this.createDocumentation((IntegrationApi)api, federatedApi.getId(), auditInfo);
                }
            });
        }).ignoreElements();
    }

    private void createDocumentation(IntegrationApi integrationApi, String referenceId, AuditInfo auditInfo) {
        integrationApi.pages().stream().flatMap(page -> {
            if (page == null || page.pageType() == null) {
                return Stream.empty();
            }
            return switch (page.pageType()) {
                default -> throw new IncompatibleClassChangeError();
                case IntegrationApi.PageType.SWAGGER -> Stream.of(this.buildSwaggerPage(integrationApi.name(), referenceId, page.content()));
                case IntegrationApi.PageType.ASYNCAPI -> Stream.of(this.buildAsyncApiPage(integrationApi.name(), referenceId, page.content()));
                case IntegrationApi.PageType.ASCIIDOC, IntegrationApi.PageType.MARKDOWN, IntegrationApi.PageType.MARKDOWN_TEMPLATE -> {
                    log.error("Impossible to import {} documentation for {}", (Object)page.pageType(), (Object)integrationApi.name());
                    yield Stream.empty();
                }
            };
        }).forEach(page -> this.createApiDocumentationDomainService.createPage((Page)page, auditInfo));
    }

    private Page buildSwaggerPage(String name, String referenceId, String content) {
        Date now = Date.from(TimeProvider.instantNow());
        return Page.builder().id(UuidString.generateRandom()).name(name.concat("-oas.yml")).content(content).type(Page.Type.valueOf(IntegrationApi.PageType.SWAGGER.name())).referenceId(referenceId).referenceType(Page.ReferenceType.API).published(true).visibility(Page.Visibility.PRIVATE).homepage(true).configuration(Map.of("tryIt", "true", "viewer", "Swagger")).createdAt(now).updatedAt(now).build();
    }

    private Page buildAsyncApiPage(String name, String referenceId, String content) {
        Date now = Date.from(TimeProvider.instantNow());
        return Page.builder().id(UuidString.generateRandom()).name(name.concat(".json")).content(content).type(Page.Type.valueOf(IntegrationApi.PageType.ASYNCAPI.name())).referenceId(referenceId).referenceType(Page.ReferenceType.API).published(true).visibility(Page.Visibility.PRIVATE).homepage(true).createdAt(now).updatedAt(now).build();
    }

    private void createApi(Api federatedApi, PrimaryOwnerEntity primaryOwner, AuditInfo auditInfo) {
        try {
            this.createApiDomainService.create(federatedApi, primaryOwner, auditInfo, this.validateFederatedApi::validateAndSanitizeForCreation);
        }
        catch (Exception e) {
            log.warn("An error occurred while importing api {}", (Object)federatedApi, (Object)e);
        }
    }

    private void createPlans(List<IntegrationApi.Plan> plans, Api federatedApi, AuditInfo auditInfo) {
        plans.stream().map(p -> {
            String id = UuidString.generateRandom();
            ZonedDateTime now = TimeProvider.now();
            return ((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)Plan.builder().id(id)).name(p.name())).description(p.description())).apiId(federatedApi.getId())).federatedPlanDefinition(FederatedPlan.builder().id(id).providerId(p.id()).security(PlanSecurity.builder().type(PlanSecurityType.valueOf((String)p.type().name()).getLabel()).build()).status(PlanStatus.PUBLISHED).build())).createdAt(now)).updatedAt(now)).validation(Plan.PlanValidationType.MANUAL)).build();
        }).forEach(p -> this.createPlanDomainService.create((Plan)p, List.of(), federatedApi, auditInfo));
    }

    @Generated
    public IngestIntegrationApisUseCase(IntegrationCrudService integrationCrudService, ApiPrimaryOwnerFactory apiPrimaryOwnerFactory, ValidateFederatedApiDomainService validateFederatedApi, ApiCrudService apiCrudService, CreateApiDomainService createApiDomainService, CreatePlanDomainService createPlanDomainService, IntegrationAgent integrationAgent, CreateApiDocumentationDomainService createApiDocumentationDomainService, LicenseDomainService licenseDomainService) {
        this.integrationCrudService = integrationCrudService;
        this.apiPrimaryOwnerFactory = apiPrimaryOwnerFactory;
        this.validateFederatedApi = validateFederatedApi;
        this.apiCrudService = apiCrudService;
        this.createApiDomainService = createApiDomainService;
        this.createPlanDomainService = createPlanDomainService;
        this.integrationAgent = integrationAgent;
        this.createApiDocumentationDomainService = createApiDocumentationDomainService;
        this.licenseDomainService = licenseDomainService;
    }

    public record Input(String integrationId, AuditInfo auditInfo) {
    }
}

