/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api_key.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api_key.crud_service.ApiKeyCrudService;
import io.gravitee.apim.core.api_key.model.ApiKeyEntity;
import io.gravitee.apim.core.api_key.query_service.ApiKeyQueryService;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.event.ApiKeyAuditEvent;
import io.gravitee.apim.core.notification.domain_service.TriggerNotificationDomainService;
import io.gravitee.apim.core.notification.model.hook.ApiKeyRevokedApiHookContext;
import io.gravitee.apim.core.subscription.crud_service.SubscriptionCrudService;
import io.gravitee.apim.core.subscription.model.SubscriptionEntity;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@DomainService
public class RevokeApiKeyDomainService {
    private final ApiKeyCrudService apiKeyCrudService;
    private final ApiKeyQueryService apiKeyQueryService;
    private final SubscriptionCrudService subscriptionCrudService;
    private final AuditDomainService auditService;
    private final TriggerNotificationDomainService triggerNotificationDomainService;

    public RevokeApiKeyDomainService(ApiKeyCrudService apiKeyCrudService, ApiKeyQueryService apiKeyQueryService, SubscriptionCrudService subscriptionCrudService, AuditDomainService auditService, TriggerNotificationDomainService triggerNotificationDomainService) {
        this.apiKeyCrudService = apiKeyCrudService;
        this.apiKeyQueryService = apiKeyQueryService;
        this.subscriptionCrudService = subscriptionCrudService;
        this.auditService = auditService;
        this.triggerNotificationDomainService = triggerNotificationDomainService;
    }

    public Set<ApiKeyEntity> revokeAllSubscriptionsApiKeys(SubscriptionEntity subscription, AuditInfo auditInfo) {
        return this.apiKeyQueryService.findBySubscription(subscription.getId()).filter(ApiKeyEntity::canBeRevoked).map(apiKeyEntity -> {
            ApiKeyEntity revokedApiKey = apiKeyEntity.revoke();
            this.apiKeyCrudService.update(revokedApiKey);
            this.createAuditLog((ApiKeyEntity)apiKeyEntity, revokedApiKey, subscription, auditInfo);
            return revokedApiKey;
        }).collect(Collectors.toSet());
    }

    public ApiKeyEntity revoke(ApiKeyEntity apiKey, AuditInfo auditInfo) {
        if (!apiKey.canBeRevoked()) {
            return apiKey;
        }
        ApiKeyEntity revoked = this.apiKeyCrudService.update(apiKey.revoke());
        apiKey.getSubscriptions().forEach(subscriptionId -> {
            SubscriptionEntity subscription = this.subscriptionCrudService.get((String)subscriptionId);
            this.createAuditLog(apiKey, revoked, subscription, auditInfo);
            this.triggerNotificationDomainService.triggerApiNotification(auditInfo.organizationId(), new ApiKeyRevokedApiHookContext(subscription.getApiId(), subscription.getApplicationId(), subscription.getPlanId(), apiKey.getKey()));
        });
        return revoked;
    }

    private void createAuditLog(ApiKeyEntity apiKeyEntity, ApiKeyEntity revokedApiKeyEntity, SubscriptionEntity subscription, AuditInfo auditInfo) {
        this.auditService.createApiAuditLog(ApiAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).apiId(subscription.getApiId()).event(ApiKeyAuditEvent.APIKEY_REVOKED).actor(auditInfo.actor()).oldValue(apiKeyEntity).newValue(revokedApiKeyEntity).createdAt(ZonedDateTime.ofInstant(revokedApiKeyEntity.getRevokedAt().toInstant(), ZoneId.systemDefault())).properties(Map.of(AuditProperties.API_KEY, apiKeyEntity.getKey(), AuditProperties.API, subscription.getApiId(), AuditProperties.APPLICATION, subscription.getApplicationId())).build());
    }
}

