/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import io.gravitee.definition.model.v4.ConnectorFeature;
import io.gravitee.definition.model.v4.ConnectorMode;
import io.gravitee.definition.model.v4.listener.ListenerType;
import io.gravitee.definition.model.v4.listener.entrypoint.Qos;
import io.gravitee.gateway.reactive.api.ApiType;
import io.gravitee.gateway.reactive.api.connector.ConnectorFactory;
import io.gravitee.gateway.reactive.api.connector.endpoint.async.EndpointAsyncConnectorFactory;
import io.gravitee.gateway.reactive.api.connector.entrypoint.EntrypointConnectorFactory;
import io.gravitee.gateway.reactive.api.connector.entrypoint.async.EntrypointAsyncConnectorFactory;
import io.gravitee.plugin.core.api.ConfigurablePlugin;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.entrypoint.EntrypointConnectorPluginManager;
import io.gravitee.rest.api.model.v4.connector.ConnectorPluginEntity;
import io.gravitee.rest.api.service.JsonSchemaService;
import io.gravitee.rest.api.service.impl.AbstractPluginService;
import io.gravitee.rest.api.service.v4.ConnectorPluginService;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public abstract class AbstractConnectorPluginService<T extends ConfigurablePlugin<?>>
extends AbstractPluginService<T, ConnectorPluginEntity>
implements ConnectorPluginService {
    protected AbstractConnectorPluginService(JsonSchemaService jsonSchemaService, ConfigurablePluginManager<T> pluginManager) {
        super(jsonSchemaService, pluginManager);
    }

    @Override
    public Set<ConnectorPluginEntity> findAll() {
        return super.list().stream().map(this::convert).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public ConnectorPluginEntity findById(String entrypointPluginId) {
        Object resourceDefinition = super.get(entrypointPluginId);
        return this.convert((Plugin)resourceDefinition);
    }

    protected abstract ConnectorFactory<?> getConnectorFactory(String var1);

    protected ConnectorPluginEntity convert(Plugin plugin) {
        EntrypointConnectorFactory entrypointConnectorFactory;
        ConnectorPluginEntity entity = new ConnectorPluginEntity();
        entity.setId(plugin.id());
        entity.setDescription(plugin.manifest().description());
        entity.setName(plugin.manifest().name());
        entity.setIcon(this.getIcon(plugin.id()));
        entity.setVersion(plugin.manifest().version());
        entity.setDeployed(plugin.deployed());
        entity.setFeature(plugin.manifest().feature());
        ConnectorFactory<?> connectorFactory = this.getConnectorFactory(plugin.id());
        if (connectorFactory.supportedApi() != null) {
            entity.setSupportedApiType(io.gravitee.definition.model.v4.ApiType.fromLabel((String)connectorFactory.supportedApi().getLabel()));
        }
        if (connectorFactory.supportedApi() == ApiType.MESSAGE) {
            Set supportedQos = null;
            if (connectorFactory instanceof EntrypointAsyncConnectorFactory) {
                supportedQos = ((EntrypointAsyncConnectorFactory)connectorFactory).supportedQos();
            } else if (connectorFactory instanceof EndpointAsyncConnectorFactory) {
                supportedQos = ((EndpointAsyncConnectorFactory)connectorFactory).supportedQos();
            }
            if (supportedQos != null) {
                entity.setSupportedQos((Set)supportedQos.stream().map(qos -> Qos.fromLabel((String)qos.getLabel())).sorted().collect(Collectors.toCollection(LinkedHashSet::new)));
            }
        }
        if (connectorFactory.supportedModes() != null) {
            entity.setSupportedModes(connectorFactory.supportedModes().stream().map(connectorMode -> ConnectorMode.fromLabel((String)connectorMode.getLabel())).collect(Collectors.toSet()));
        }
        if (connectorFactory.supportedApi() != null) {
            entity.setSupportedApiType(io.gravitee.definition.model.v4.ApiType.fromLabel((String)connectorFactory.supportedApi().getLabel()));
        }
        if (connectorFactory instanceof EntrypointConnectorFactory && (entrypointConnectorFactory = (EntrypointConnectorFactory)connectorFactory).supportedListenerType() != null) {
            entity.setSupportedListenerType(ListenerType.fromLabel((String)entrypointConnectorFactory.supportedListenerType().getLabel()));
        }
        if (plugin.manifest().properties() != null && plugin.manifest().properties().get("features") != null && !((String)plugin.manifest().properties().get("features")).isEmpty()) {
            entity.setAvailableFeatures(Arrays.stream(((String)plugin.manifest().properties().get("features")).split(",")).map(ConnectorFeature::fromLabel).collect(Collectors.toSet()));
        } else {
            entity.setAvailableFeatures(Collections.emptySet());
        }
        return entity;
    }

    @Override
    public Set<ConnectorPluginEntity> findBySupportedApi(io.gravitee.definition.model.v4.ApiType apiType) {
        return super.list().stream().filter(plugin -> ((EntrypointConnectorPluginManager)this.pluginManager).getFactoryById(plugin.id(), true).supportedApi().equals((Object)ApiType.fromLabel((String)apiType.getLabel()))).map(this::convert).collect(Collectors.toSet());
    }

    @Override
    public Set<ConnectorPluginEntity> findByConnectorMode(ConnectorMode connectorMode) {
        return super.list().stream().filter(plugin -> ((EntrypointConnectorPluginManager)this.pluginManager).getFactoryById(plugin.id(), true).supportedModes().contains(io.gravitee.gateway.reactive.api.ConnectorMode.fromLabel((String)connectorMode.getLabel()))).map(this::convert).collect(Collectors.toSet());
    }

    @Override
    public String validateConnectorConfiguration(String connectorPluginId, String configuration) {
        ConnectorPluginEntity connectorPluginEntity = this.findById(connectorPluginId);
        return this.validateConfiguration(connectorPluginEntity.getId(), configuration);
    }

    @Override
    public String validateConnectorConfiguration(ConnectorPluginEntity connectorPluginEntity, String configuration) {
        return this.validateConfiguration(connectorPluginEntity.getId(), configuration);
    }

    protected String validatePluginConfigurationAgainstSchema(String pluginId, String configuration, UnaryOperator<String> schemaProvider) {
        if (pluginId != null && configuration != null) {
            String schema = (String)schemaProvider.apply(pluginId);
            return this.jsonSchemaService.validate(schema, configuration);
        }
        return configuration;
    }
}

