/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import io.gravitee.cockpit.api.command.v1.CockpitCommandType;
import io.gravitee.cockpit.api.command.v1.user.UserCommand;
import io.gravitee.cockpit.api.command.v1.user.UserCommandPayload;
import io.gravitee.cockpit.api.command.v1.user.UserReply;
import io.gravitee.exchange.api.command.CommandHandler;
import io.gravitee.rest.api.model.NewExternalUserEntity;
import io.gravitee.rest.api.model.UpdateUserEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import io.reactivex.rxjava3.core.Single;
import java.util.HashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UserCommandHandler
implements CommandHandler<UserCommand, UserReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserCommandHandler.class);
    public static final String COCKPIT_SOURCE = "cockpit";
    private final UserService userService;

    public String supportType() {
        return CockpitCommandType.USER.name();
    }

    public Single<UserReply> handle(UserCommand command) {
        UserCommandPayload userPayload = (UserCommandPayload)command.getPayload();
        ExecutionContext executionContext = new ExecutionContext(userPayload.organizationId(), null);
        try {
            UserEntity existingUser = this.userService.findBySource(userPayload.organizationId(), COCKPIT_SOURCE, userPayload.id(), false);
            UpdateUserEntity updatedUser = new UpdateUserEntity();
            updatedUser.setFirstname(userPayload.firstName());
            updatedUser.setLastname(userPayload.lastName());
            updatedUser.setEmail(userPayload.email());
            updatedUser.setPicture(userPayload.picture());
            updatedUser.setCustomFields(new HashMap());
            if (userPayload.additionalInformation() != null) {
                updatedUser.getCustomFields().putAll(userPayload.additionalInformation());
            }
            updatedUser.getCustomFields().computeIfAbsent("picture", k -> userPayload.picture());
            updatedUser.getCustomFields().computeIfAbsent("sub", k -> userPayload.username());
            UserEntity cockpitUserEntity = this.userService.update(executionContext, existingUser.getId(), updatedUser);
            log.info("User [{}] with APIM id [{}] updated.", (Object)userPayload.username(), (Object)cockpitUserEntity.getId());
            return Single.just((Object)new UserReply(command.getId()));
        }
        catch (UserNotFoundException unfe) {
            NewExternalUserEntity newUser = new NewExternalUserEntity();
            newUser.setSourceId(userPayload.id());
            newUser.setFirstname(userPayload.firstName());
            newUser.setLastname(userPayload.lastName());
            newUser.setEmail(userPayload.email());
            newUser.setPicture(userPayload.picture());
            newUser.setSource(COCKPIT_SOURCE);
            newUser.setCustomFields(new HashMap());
            if (userPayload.additionalInformation() != null) {
                newUser.getCustomFields().putAll(userPayload.additionalInformation());
            }
            newUser.getCustomFields().computeIfAbsent("picture", k -> userPayload.picture());
            newUser.getCustomFields().computeIfAbsent("sub", k -> userPayload.username());
            try {
                UserEntity cockpitUserEntity = this.userService.create(executionContext, newUser, false);
                log.info("User [{}] created with APIM id [{}].", (Object)userPayload.username(), (Object)cockpitUserEntity.getId());
                return Single.just((Object)new UserReply(command.getId()));
            }
            catch (Exception e) {
                String errorDetails = "Error occurred when creating user [%s] for organization [%s].".formatted(userPayload.username(), userPayload.organizationId());
                log.error(errorDetails, (Throwable)e);
                return Single.just((Object)new UserReply(command.getId(), errorDetails));
            }
        }
        catch (Exception e) {
            String errorDetails = "Error occurred when updating user [%s] for organization [%s].".formatted(userPayload.username(), userPayload.organizationId());
            log.error(errorDetails, (Throwable)e);
            return Single.just((Object)new UserReply(command.getId(), errorDetails));
        }
    }

    @Generated
    public UserCommandHandler(UserService userService) {
        this.userService = userService;
    }
}

