/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.user;

import io.gravitee.apim.core.user.crud_service.UserCrudService;
import io.gravitee.apim.core.user.model.BaseUserEntity;
import io.gravitee.apim.infra.adapter.UserAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.UserRepository;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class UserCrudServiceImpl
implements UserCrudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserCrudServiceImpl.class);
    private final UserRepository userRepository;

    public UserCrudServiceImpl(@Lazy UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Override
    public Optional<BaseUserEntity> findBaseUserById(String id) {
        try {
            log.debug("Find user [userId={}]", (Object)id);
            Optional optionalUser = this.userRepository.findById((Object)id);
            return optionalUser.map(UserAdapter.INSTANCE::fromUser);
        }
        catch (TechnicalException ex) {
            log.error("An error occurs while trying to find user using [userId={}]", (Object)id, (Object)ex);
            throw new TechnicalManagementException(ex);
        }
    }

    @Override
    public Set<BaseUserEntity> findBaseUsersByIds(List<String> userIds) {
        try {
            log.debug("Find users [userIds={}]", userIds);
            return this.userRepository.findByIds(userIds).stream().map(UserAdapter.INSTANCE::fromUser).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            log.error("An error occurs while trying to find user using [userIds={}]", userIds, (Object)ex);
            throw new TechnicalManagementException(ex);
        }
    }

    @Override
    public BaseUserEntity getBaseUser(String id) {
        try {
            log.debug("Find user [userId={}]", (Object)id);
            Optional optionalUser = this.userRepository.findById((Object)id);
            return optionalUser.map(UserAdapter.INSTANCE::fromUser).orElseThrow(() -> new UserNotFoundException(id));
        }
        catch (TechnicalException ex) {
            log.error("An error occurs while trying to get user using [userId={}]", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to get user " + id, ex);
        }
    }
}

