/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.application;

import io.gravitee.apim.core.application.crud_service.ApplicationCrudService;
import io.gravitee.apim.infra.adapter.ApplicationAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApplicationRepository;
import io.gravitee.repository.management.model.Application;
import io.gravitee.rest.api.model.BaseApplicationEntity;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.ApplicationNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ApplicationCrudServiceImpl
implements ApplicationCrudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplicationCrudServiceImpl.class);
    private final ApplicationRepository applicationRepository;

    public ApplicationCrudServiceImpl(@Lazy ApplicationRepository applicationRepository) {
        this.applicationRepository = applicationRepository;
    }

    @Override
    public BaseApplicationEntity findById(ExecutionContext executionContext, String applicationId) {
        return this.findById(applicationId, executionContext.getEnvironmentId());
    }

    @Override
    public BaseApplicationEntity findById(String applicationId, String environmentId) {
        try {
            log.debug("Find application by id: {}", (Object)applicationId);
            Optional<Application> applicationOptional = this.applicationRepository.findById((Object)applicationId);
            if (environmentId != null) {
                applicationOptional = applicationOptional.filter(result -> result.getEnvironmentId().equals(environmentId));
            }
            return applicationOptional.map(ApplicationAdapter.INSTANCE::toEntity).orElseThrow(() -> new ApplicationNotFoundException(applicationId));
        }
        catch (TechnicalException ex) {
            log.error("An error occurs while trying to find an application using its ID {}", (Object)applicationId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find an application using its ID " + applicationId, ex);
        }
    }
}

