/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.documentation.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.documentation.crud_service.PageCrudService;
import io.gravitee.apim.core.documentation.domain_service.ApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.domain_service.UpdateApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.exception.ValidationDomainException;
import java.util.Date;
import java.util.Map;

@UseCase
public class ApiPublishDocumentationPageUseCase {
    private final ApiDocumentationDomainService apiDocumentationDomainService;
    private final UpdateApiDocumentationDomainService updateApiDocumentationDomainService;
    private final ApiCrudService apiCrudService;
    private final PageCrudService pageCrudService;

    public ApiPublishDocumentationPageUseCase(ApiDocumentationDomainService apiDocumentationDomainService, UpdateApiDocumentationDomainService updateApiDocumentationDomainService, ApiCrudService apiCrudService, PageCrudService pageCrudService) {
        this.apiDocumentationDomainService = apiDocumentationDomainService;
        this.updateApiDocumentationDomainService = updateApiDocumentationDomainService;
        this.apiCrudService = apiCrudService;
        this.pageCrudService = pageCrudService;
    }

    public Output execute(Input input) {
        this.apiCrudService.get(input.apiId);
        Page page = this.pageCrudService.get(input.pageId);
        this.apiDocumentationDomainService.validatePageAssociatedToApi(page, input.apiId);
        if (page.isPublished()) {
            throw new ValidationDomainException("Page is already published.", Map.of("id", page.getId()));
        }
        Page newPage = page.toBuilder().published(true).updatedAt(new Date()).build();
        Page updatedPage = this.updateApiDocumentationDomainService.updatePage(newPage, page, input.auditInfo);
        updatedPage = updatedPage.withHidden(this.apiDocumentationDomainService.pageIsHidden(updatedPage));
        return new Output(updatedPage);
    }

    public record Input(String apiId, String pageId, AuditInfo auditInfo) {
    }

    public record Output(Page page) {
    }
}

