/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import com.google.common.base.Functions;
import io.gravitee.apim.core.api.model.crd.ApiCRDSpec;
import io.gravitee.apim.core.api.model.crd.MemberCRD;
import io.gravitee.apim.core.api.model.crd.PageCRD;
import io.gravitee.apim.core.api.model.crd.PlanCRD;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.ExportApiEntity;
import io.gravitee.rest.api.model.v4.plan.PlanEntity;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

@Mapper
public interface ApiCRDAdapter {
    public static final ApiCRDAdapter INSTANCE = (ApiCRDAdapter)Mappers.getMapper(ApiCRDAdapter.class);

    @Mappings(value={@Mapping(target="version", source="apiEntity.apiVersion"), @Mapping(target="metadata", source="exportEntity.metadata"), @Mapping(target="definitionContext", ignore=true), @Mapping(target="plans", expression="java(mapPlans(exportEntity))"), @Mapping(target="pages", expression="java(mapPages(exportEntity))"), @Mapping(target="members", expression="java(mapMembers(exportEntity))")})
    public ApiCRDSpec toCRDSpec(ExportApiEntity var1, ApiEntity var2);

    public PlanCRD toCRDPlan(PlanEntity var1);

    default public Map<String, PlanCRD> mapPlans(ExportApiEntity definition) {
        return definition.getPlans().stream().map(this::toCRDPlan).collect(Collectors.toMap(PlanCRD::getName, Functions.identity()));
    }

    public PageCRD toCRDPage(PageEntity var1);

    default public Map<String, PageCRD> mapPages(ExportApiEntity definition) {
        return definition.getPages() != null ? definition.getPages().stream().map(this::toCRDPage).collect(Collectors.toMap(PageCRD::getName, Functions.identity())) : null;
    }

    default public Set<MemberCRD> mapMembers(ExportApiEntity definition) {
        return definition.getMembers() != null ? definition.getMembers().stream().map(me -> new MemberCRD(me.getId(), null, null, me.getDisplayName(), ((RoleEntity)me.getRoles().get(0)).getName())).collect(Collectors.toSet()) : null;
    }
}

