/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.model.factory;

import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.NewApi;
import io.gravitee.apim.core.api.model.crd.ApiCRDSpec;
import io.gravitee.apim.core.api.model.import_definition.ApiExport;
import io.gravitee.apim.core.integration.model.Integration;
import io.gravitee.apim.core.integration.model.IntegrationApi;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.rest.api.model.context.IntegrationContext;
import io.gravitee.rest.api.model.context.OriginContext;
import io.gravitee.rest.api.service.common.UuidString;
import java.time.ZonedDateTime;

public class ApiModelFactory {
    private ApiModelFactory() {
    }

    public static Api fromNewApi(NewApi newApi, String environmentId) {
        String id = UuidString.generateRandom();
        ZonedDateTime now = TimeProvider.now();
        return ((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)newApi.toApiBuilder().id(id)).environmentId(environmentId)).createdAt(now)).updatedAt(now)).apiDefinitionV4(newApi.toApiDefinitionBuilder().id(id).build())).lifecycleState(Api.LifecycleState.STOPPED)).build();
    }

    public static Api fromCrd(ApiCRDSpec crd, String environmentId) {
        String id = crd.getId() != null ? crd.getId() : UuidString.generateRandom();
        ZonedDateTime now = TimeProvider.now();
        return ((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)crd.toApiBuilder().id(id)).environmentId(environmentId)).createdAt(now)).updatedAt(now)).visibility(Api.Visibility.valueOf(crd.getVisibility()))).apiDefinitionV4(crd.toApiDefinitionBuilder().id(id).build())).build();
    }

    public static Api fromApiExport(ApiExport api, String environmentId) {
        String id = api.getId() != null ? api.getId() : UuidString.generateRandom();
        ZonedDateTime now = TimeProvider.now();
        return ((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)api.toApiBuilder().id(id)).environmentId(environmentId)).createdAt(now)).updatedAt(now)).lifecycleState(Api.LifecycleState.STOPPED)).apiLifecycleState(Api.ApiLifecycleState.CREATED)).visibility(api.getVisibility() == null ? Api.Visibility.PRIVATE : Api.Visibility.valueOf(api.getVisibility().name()))).apiDefinitionV4(api.toApiDefinitionBuilder().id(id).build())).build();
    }

    public static Api fromIntegration(IntegrationApi integrationApi, Integration integration) {
        String id = ApiModelFactory.generateFederatedApiId(integrationApi, integration);
        ZonedDateTime now = TimeProvider.now();
        String defaultVersion = "0.0.0";
        String version = integrationApi.version() != null ? integrationApi.version() : defaultVersion;
        return ((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)Api.builder().id(id)).version(version)).definitionVersion(DefinitionVersion.FEDERATED)).name(integrationApi.name())).description(integrationApi.description())).createdAt(now)).updatedAt(now)).environmentId(integration.getEnvironmentId())).lifecycleState(null)).originContext((OriginContext)new IntegrationContext(integration.getId()))).federatedApiDefinition(integrationApi.toFederatedApiDefinitionBuilder().id(id).build())).build();
    }

    public static String generateFederatedApiId(IntegrationApi integrationApi, Integration integration) {
        return UuidString.generateForEnvironment(integration.getEnvironmentId(), integration.getId(), integrationApi.uniqueId());
    }
}

