/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.domain_service.ApiMetadataDecoderDomainService;
import io.gravitee.apim.core.api.exception.DuplicateApiMetadataKeyException;
import io.gravitee.apim.core.api.exception.DuplicateApiMetadataNameException;
import io.gravitee.apim.core.api.exception.InvalidApiMetadataValueException;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.query_service.ApiMetadataQueryService;
import io.gravitee.apim.core.membership.domain_service.ApiPrimaryOwnerDomainService;
import io.gravitee.apim.core.metadata.crud_service.MetadataCrudService;
import io.gravitee.apim.core.metadata.model.Metadata;
import io.gravitee.apim.core.metadata.model.MetadataId;
import jakarta.mail.internet.InternetAddress;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;

@DomainService
public class ValidateApiMetadataDomainService {
    private final ApiMetadataQueryService metadataQueryService;
    private final MetadataCrudService metadataCrudService;
    private final ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService;
    private final ApiMetadataDecoderDomainService apiMetadataDecoderDomainService;
    private final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public void validateUniqueKey(String apiId, String key) {
        this.metadataCrudService.findById(MetadataId.builder().key(key).referenceId(apiId).referenceType(Metadata.ReferenceType.API).build()).ifPresent(m -> {
            throw new DuplicateApiMetadataKeyException(apiId, key);
        });
    }

    public void validateUniqueName(String apiId, String name) {
        this.metadataQueryService.findApiMetadata(apiId).values().forEach(val -> {
            if (val.getName().equalsIgnoreCase(name)) {
                throw new DuplicateApiMetadataNameException(apiId, name);
            }
        });
    }

    public void validateValueByFormat(Api api, String organizationId, String value, Metadata.MetadataFormat format) {
        String valueToCheck = Objects.nonNull(value) && value.startsWith("${") ? this.getDecodedValue(api, organizationId, value) : value;
        try {
            switch (format) {
                case URL: {
                    new URL(valueToCheck);
                    break;
                }
                case MAIL: {
                    InternetAddress email = new InternetAddress(valueToCheck);
                    email.validate();
                    break;
                }
                case DATE: {
                    this.SIMPLE_DATE_FORMAT.setLenient(false);
                    this.SIMPLE_DATE_FORMAT.parse(valueToCheck);
                    break;
                }
                case NUMERIC: {
                    Double.valueOf(valueToCheck);
                }
            }
        }
        catch (Exception e) {
            throw new InvalidApiMetadataValueException(value, format.name());
        }
    }

    private String getDecodedValue(Api api, String organizationId, String value) {
        ApiMetadataDecoderDomainService.ApiMetadataDecodeContext apiTemplate = new ApiMetadataDecoderDomainService.ApiMetadataDecodeContext(api, Map.of(), this.apiPrimaryOwnerDomainService.getApiPrimaryOwner(organizationId, api.getId()));
        return this.apiMetadataDecoderDomainService.decodeMetadataValue(value, apiTemplate);
    }

    @Generated
    public ValidateApiMetadataDomainService(ApiMetadataQueryService metadataQueryService, MetadataCrudService metadataCrudService, ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService, ApiMetadataDecoderDomainService apiMetadataDecoderDomainService) {
        this.metadataQueryService = metadataQueryService;
        this.metadataCrudService = metadataCrudService;
        this.apiPrimaryOwnerDomainService = apiPrimaryOwnerDomainService;
        this.apiMetadataDecoderDomainService = apiMetadataDecoderDomainService;
    }
}

