/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.domain_service;

import io.gravitee.apim.core.api.model.ApiMetadata;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.event.ApiAuditEvent;
import io.gravitee.apim.core.datetime.TimeProvider;
import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.metadata.crud_service.MetadataCrudService;
import io.gravitee.apim.core.metadata.model.Metadata;
import io.gravitee.common.utils.IdGenerator;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

public class ApiMetadataDomainService {
    private final MetadataCrudService metadataCrudService;
    private final AuditDomainService auditService;

    public ApiMetadataDomainService(MetadataCrudService metadataCrudService, AuditDomainService auditService) {
        this.metadataCrudService = metadataCrudService;
        this.auditService = auditService;
    }

    public void createDefaultApiMetadata(String apiId, AuditInfo auditInfo) {
        ZonedDateTime now = TimeProvider.now();
        String name = "email-support";
        Metadata emailSupportMetadata = this.metadataCrudService.create(Metadata.builder().key(IdGenerator.generate((String)name)).format(Metadata.MetadataFormat.MAIL).name(name).value("${(api.primaryOwner.email)!''}").referenceType(Metadata.ReferenceType.API).referenceId(apiId).createdAt(now).updatedAt(now).build());
        this.createAuditLog(emailSupportMetadata, auditInfo);
    }

    public void saveApiMetadata(String apiId, List<ApiMetadata> metadata, AuditInfo auditInfo) {
        throw new TechnicalDomainException("Not yet implemented");
    }

    private void createAuditLog(Metadata created, AuditInfo auditInfo) {
        this.auditService.createApiAuditLog(ApiAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).apiId(created.getReferenceId()).event(ApiAuditEvent.METADATA_CREATED).actor(auditInfo.actor()).newValue(created).createdAt(created.getCreatedAt()).properties(Map.of(AuditProperties.METADATA, created.getKey())).build());
    }
}

