/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.EnvironmentRepository;
import io.gravitee.repository.management.model.Environment;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.MembershipEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.UpdateEnvironmentEntity;
import io.gravitee.rest.api.service.ApiHeaderService;
import io.gravitee.rest.api.service.DashboardService;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.OrganizationService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.EnvironmentNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class EnvironmentServiceImpl
extends TransactionalService
implements EnvironmentService {
    private final Logger LOGGER = LoggerFactory.getLogger(EnvironmentServiceImpl.class);
    @Lazy
    @Autowired
    private EnvironmentRepository environmentRepository;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private ApiHeaderService apiHeaderService;
    @Autowired
    private PageService pageService;
    @Autowired
    private MembershipService membershipService;
    @Autowired
    private DashboardService dashboardService;

    @Override
    public EnvironmentEntity findById(String environmentId) {
        try {
            this.LOGGER.debug("Find environment by ID: {}", (Object)environmentId);
            Optional optEnvironment = this.environmentRepository.findById((Object)environmentId);
            if (!optEnvironment.isPresent()) {
                throw new EnvironmentNotFoundException(environmentId);
            }
            return this.convert((Environment)optEnvironment.get());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find environment by ID", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find environment by ID", ex);
        }
    }

    @Override
    public List<EnvironmentEntity> findByUser(String organizationId, String userId) {
        try {
            this.LOGGER.debug("Find all environments by user");
            Stream<Object> envStream = this.environmentRepository.findByOrganization(organizationId).stream();
            if (userId != null) {
                List stringStream = this.membershipService.getMembershipsByMemberAndReference(MembershipMemberType.USER, userId, MembershipReferenceType.ENVIRONMENT).stream().map(MembershipEntity::getReferenceId).collect(Collectors.toList());
                envStream = envStream.filter(env -> stringStream.contains(env.getId()));
            }
            return envStream.map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find all environments", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all environments", ex);
        }
    }

    @Override
    public EnvironmentEntity findByOrgAndIdOrHrid(String organizationId, String idOrHrid) {
        try {
            this.LOGGER.debug("Find all environments by org and environment id or hrid");
            Set byOrgAndIdOrHrid = this.environmentRepository.findByOrganization(organizationId).stream().filter(Objects::nonNull).filter(env -> env.getId().equals(idOrHrid) || env.getHrids().contains(idOrHrid)).collect(Collectors.toSet());
            if (byOrgAndIdOrHrid.isEmpty()) {
                throw new EnvironmentNotFoundException(idOrHrid);
            }
            if (byOrgAndIdOrHrid.size() > 1) {
                throw new IllegalStateException("More than one environment found for hrid or id " + idOrHrid);
            }
            return this.convert((Environment)byOrgAndIdOrHrid.iterator().next());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find all environments", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all environments", ex);
        }
    }

    @Override
    public EnvironmentEntity createOrUpdate(String organizationId, String environmentId, UpdateEnvironmentEntity environmentEntity) {
        try {
            this.organizationService.findById(organizationId);
            Optional environmentOptional = this.environmentRepository.findById((Object)environmentId);
            Environment environment = this.convert(environmentEntity);
            environment.setId(environmentId);
            environment.setOrganizationId(organizationId);
            if (environmentOptional.isPresent()) {
                return this.convert((Environment)this.environmentRepository.update((Object)environment));
            }
            EnvironmentEntity createdEnvironment = this.convert((Environment)this.environmentRepository.create((Object)environment));
            ExecutionContext executionContext = new ExecutionContext(organizationId, environmentId);
            this.apiHeaderService.initialize(executionContext);
            this.pageService.initialize(executionContext);
            this.dashboardService.initialize(executionContext);
            return createdEnvironment;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to update environment {}", (Object)environmentEntity.getName(), (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to update environment " + environmentEntity.getName(), ex);
        }
    }

    @Override
    public void delete(String environmentId) {
        try {
            Optional environmentOptional = this.environmentRepository.findById((Object)environmentId);
            if (!environmentOptional.isPresent()) {
                throw new EnvironmentNotFoundException(environmentId);
            }
            this.environmentRepository.delete((Object)environmentId);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete environment {}", (Object)environmentId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete environment " + environmentId, ex);
        }
    }

    @Override
    public EnvironmentEntity initialize() {
        Environment defaultEnvironment = new Environment();
        defaultEnvironment.setId(GraviteeContext.getDefaultEnvironment());
        defaultEnvironment.setName("Default environment");
        defaultEnvironment.setHrids(Collections.singletonList("default"));
        defaultEnvironment.setDescription("Default environment");
        defaultEnvironment.setOrganizationId(GraviteeContext.getDefaultOrganization());
        try {
            this.environmentRepository.create((Object)defaultEnvironment);
            return this.convert(defaultEnvironment);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create default environment", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to create default environment", ex);
        }
    }

    @Override
    public EnvironmentEntity findByCockpitId(String cockpitId) {
        try {
            this.LOGGER.debug("Find environment by cockpit id");
            return this.environmentRepository.findByCockpitId(cockpitId).map(this::convert).orElseThrow(() -> new EnvironmentNotFoundException(cockpitId));
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find environment by cockpit id {}", (Object)cockpitId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find environment by cockpit id " + cockpitId, ex);
        }
    }

    @Override
    public List<EnvironmentEntity> findByOrganization(String organizationId) {
        try {
            this.LOGGER.debug("Find all environments by organization");
            return this.environmentRepository.findByOrganization(organizationId).stream().map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find all environments by organization {}", (Object)organizationId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all environments by organization " + organizationId, ex);
        }
    }

    @Override
    public EnvironmentEntity getDefaultOrInitialize() {
        try {
            return this.environmentRepository.findById((Object)GraviteeContext.getDefaultEnvironment()).map(this::convert).orElseGet(this::initialize);
        }
        catch (Exception ex) {
            this.LOGGER.error("Error while getting installation : {}", (Object)ex.getMessage());
            throw new TechnicalManagementException("Error while getting installation", ex);
        }
    }

    @Override
    public Set<EnvironmentEntity> findAllOrInitialize() {
        try {
            Set<EnvironmentEntity> environments = this.environmentRepository.findAll().stream().map(this::convert).collect(Collectors.toSet());
            if (environments.isEmpty()) {
                return Set.of(this.initialize());
            }
            return environments;
        }
        catch (Exception ex) {
            this.LOGGER.error("Error while getting installation : {}", (Object)ex.getMessage());
            throw new TechnicalManagementException("Error while getting installation", ex);
        }
    }

    private Environment convert(UpdateEnvironmentEntity environmentEntity) {
        Environment environment = new Environment();
        environment.setCockpitId(environmentEntity.getCockpitId());
        environment.setHrids(environmentEntity.getHrids());
        environment.setName(environmentEntity.getName());
        environment.setDescription(environmentEntity.getDescription());
        return environment;
    }

    private EnvironmentEntity convert(Environment environment) {
        EnvironmentEntity environmentEntity = new EnvironmentEntity();
        environmentEntity.setId(environment.getId());
        environmentEntity.setCockpitId(environment.getCockpitId());
        environmentEntity.setHrids(environment.getHrids());
        environmentEntity.setName(environment.getName());
        environmentEntity.setDescription(environment.getDescription());
        environmentEntity.setOrganizationId(environment.getOrganizationId());
        return environmentEntity;
    }
}

