/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.audit.domain_service;

import io.gravitee.apim.core.api.model.ApiAuditQueryFilters;
import io.gravitee.apim.core.audit.model.AuditEntity;
import io.gravitee.apim.core.audit.query_service.AuditMetadataQueryService;
import io.gravitee.apim.core.audit.query_service.AuditQueryService;
import io.gravitee.common.data.domain.MetadataPage;
import io.gravitee.rest.api.model.common.Pageable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchAuditDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchAuditDomainService.class);
    private final AuditQueryService auditQueryService;
    private final AuditMetadataQueryService auditMetadataQueryService;

    public SearchAuditDomainService(AuditQueryService auditQueryService, AuditMetadataQueryService auditMetadataQueryService) {
        this.auditQueryService = auditQueryService;
        this.auditMetadataQueryService = auditMetadataQueryService;
    }

    public MetadataPage<AuditEntity> searchApiAudit(ApiAuditQueryFilters query, Pageable pageable) {
        AuditQueryService.SearchResponse response = this.auditQueryService.searchApiAudit(query, pageable);
        return new MetadataPage(response.audits(), pageable.getPageNumber(), pageable.getPageSize(), response.total(), this.buildMetadata(response.audits()));
    }

    private Map<String, String> buildMetadata(List<AuditEntity> audits) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (AuditEntity audit : audits) {
            String apiMetadataKey;
            String userMetadataKey = SearchAuditDomainService.nameMetadataKey("USER", audit.getUser());
            if (!metadata.containsKey(userMetadataKey)) {
                metadata.put(userMetadataKey, this.auditMetadataQueryService.fetchUserNameMetadata(audit.getUser()));
            }
            if (!metadata.containsKey(apiMetadataKey = SearchAuditDomainService.nameMetadataKey("API", audit.getReferenceId()))) {
                metadata.put(apiMetadataKey, this.auditMetadataQueryService.fetchApiNameMetadata(audit.getReferenceId()));
            }
            if (audit.getProperties() == null) continue;
            for (Map.Entry<String, String> property : audit.getProperties().entrySet()) {
                String propertyMetadataKey = SearchAuditDomainService.nameMetadataKey(property.getKey(), property.getValue());
                if (metadata.containsKey(propertyMetadataKey)) continue;
                metadata.put(propertyMetadataKey, this.auditMetadataQueryService.fetchPropertyMetadata(audit, property.getKey(), property.getValue()));
            }
        }
        return metadata;
    }

    public static String nameMetadataKey(String type, String value) {
        return new StringJoiner(":").add(type).add(value).add("name").toString();
    }
}

