/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.cockpit.api.command.CommandStatus;
import io.gravitee.cockpit.api.command.bridge.BridgeCommand;
import io.gravitee.cockpit.api.command.bridge.BridgeMultiReply;
import io.gravitee.cockpit.api.command.bridge.BridgeReply;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.promotion.PromotionEntity;
import io.gravitee.rest.api.model.promotion.PromotionTargetEntity;
import io.gravitee.rest.api.service.cockpit.command.CockpitCommandService;
import io.gravitee.rest.api.service.cockpit.command.bridge.BridgeCommandFactory;
import io.gravitee.rest.api.service.cockpit.services.CockpitPromotionService;
import io.gravitee.rest.api.service.cockpit.services.CockpitReply;
import io.gravitee.rest.api.service.cockpit.services.CockpitReplyStatus;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CockpitPromotionServiceImpl
implements CockpitPromotionService {
    private final Logger logger = LoggerFactory.getLogger(CockpitPromotionServiceImpl.class);
    private final BridgeCommandFactory bridgeCommandFactory;
    private final CockpitCommandService cockpitCommandService;
    private final ObjectMapper objectMapper;

    public CockpitPromotionServiceImpl(BridgeCommandFactory bridgeCommandFactory, CockpitCommandService cockpitCommandService, ObjectMapper objectMapper) {
        this.bridgeCommandFactory = bridgeCommandFactory;
        this.cockpitCommandService = cockpitCommandService;
        this.objectMapper = objectMapper;
    }

    @Override
    public CockpitReply<List<PromotionTargetEntity>> listPromotionTargets(String organizationId, String environmentId) {
        BridgeCommand listEnvironmentCommand = this.bridgeCommandFactory.createListEnvironmentCommand(organizationId, environmentId);
        BridgeReply bridgeReply = this.cockpitCommandService.send(listEnvironmentCommand);
        if (bridgeReply.getCommandStatus() != CommandStatus.SUCCEEDED) {
            this.logger.warn("Problem while listing promotion targets through cockpit. \n {}", (Object)bridgeReply.getMessage());
            return new CockpitReply<List<PromotionTargetEntity>>(Collections.emptyList(), CockpitReplyStatus.ERROR);
        }
        List environmentEntities = ((BridgeMultiReply)bridgeReply).getReplies().stream().filter(simpleReply -> CommandStatus.SUCCEEDED == simpleReply.getCommandStatus()).map(simpleReply -> {
            try {
                EnvironmentEntity environmentEntity = (EnvironmentEntity)this.objectMapper.readValue(simpleReply.getPayload(), EnvironmentEntity.class);
                return new PromotionTargetEntity(environmentEntity, simpleReply.getOrganizationId(), simpleReply.getEnvironmentId(), simpleReply.getInstallationId());
            }
            catch (JsonProcessingException e) {
                this.logger.warn("Problem while deserializing environment {} with payload {}", (Object)simpleReply.getEnvironmentId(), (Object)simpleReply.getPayload());
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return new CockpitReply<List<PromotionTargetEntity>>(environmentEntities, CockpitReplyStatus.SUCCEEDED);
    }

    @Override
    public CockpitReply<PromotionEntity> requestPromotion(ExecutionContext executionContext, PromotionEntity promotionEntity) {
        String serializedPromotion = null;
        try {
            serializedPromotion = this.objectMapper.writeValueAsString((Object)promotionEntity);
        }
        catch (JsonProcessingException e) {
            this.logger.warn("Problem while serializing promotion {}", (Object)promotionEntity.getId());
        }
        BridgeCommand promoteApiCommand = this.bridgeCommandFactory.createPromoteApiCommand(executionContext.getOrganizationId(), executionContext.getEnvironmentId(), promotionEntity.getTargetEnvCockpitId(), serializedPromotion);
        BridgeReply bridgeReply = this.cockpitCommandService.send(promoteApiCommand);
        if (bridgeReply.getCommandStatus() != CommandStatus.SUCCEEDED) {
            this.logger.warn("Problem while sending API promotion request through cockpit. \n {}", (Object)bridgeReply.getMessage());
            return new CockpitReply<Object>(null, CockpitReplyStatus.ERROR);
        }
        return new CockpitReply<PromotionEntity>(promotionEntity, CockpitReplyStatus.SUCCEEDED);
    }

    @Override
    public CockpitReply<PromotionEntity> processPromotion(ExecutionContext executionContext, PromotionEntity promotionEntity) {
        String serializedPromotion = null;
        try {
            serializedPromotion = this.objectMapper.writeValueAsString((Object)promotionEntity);
        }
        catch (JsonProcessingException e) {
            this.logger.warn("Problem while serializing promotion {}", (Object)promotionEntity.getId());
        }
        BridgeCommand processPromotionCommand = this.bridgeCommandFactory.createProcessPromotionCommand(executionContext.getOrganizationId(), executionContext.getEnvironmentId(), promotionEntity.getSourceEnvCockpitId(), serializedPromotion);
        BridgeReply bridgeReply = this.cockpitCommandService.send(processPromotionCommand);
        if (bridgeReply.getCommandStatus() != CommandStatus.SUCCEEDED) {
            this.logger.warn("Problem while processing API promotion request through cockpit. \n {}", (Object)bridgeReply.getMessage());
            return new CockpitReply<Object>(null, CockpitReplyStatus.ERROR);
        }
        return new CockpitReply<PromotionEntity>(promotionEntity, CockpitReplyStatus.SUCCEEDED);
    }
}

