/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.datetime.TimeProvider;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.definition.model.v4.flow.selector.ChannelSelector;
import io.gravitee.definition.model.v4.flow.selector.ConditionSelector;
import io.gravitee.definition.model.v4.flow.selector.HttpSelector;
import io.gravitee.definition.model.v4.flow.selector.Selector;
import io.gravitee.repository.management.model.flow.FlowReferenceType;
import io.gravitee.repository.management.model.flow.selector.FlowChannelSelector;
import io.gravitee.repository.management.model.flow.selector.FlowConditionSelector;
import io.gravitee.repository.management.model.flow.selector.FlowHttpSelector;
import io.gravitee.repository.management.model.flow.selector.FlowSelector;
import io.gravitee.rest.api.service.common.UuidString;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

@Mapper(imports={UuidString.class, TimeProvider.class})
public interface FlowAdapter {
    public static final FlowAdapter INSTANCE = (FlowAdapter)Mappers.getMapper(FlowAdapter.class);

    @Mappings(value={@Mapping(target="id", expression="java(UuidString.generateRandom())"), @Mapping(target="createdAt", expression="java(java.util.Date.from(TimeProvider.instantNow()))"), @Mapping(target="updatedAt", expression="java(java.util.Date.from(TimeProvider.instantNow()))")})
    public io.gravitee.repository.management.model.flow.Flow toRepository(io.gravitee.definition.model.v4.flow.Flow var1, FlowReferenceType var2, String var3, int var4);

    @Mappings(value={@Mapping(target="id", ignore=true), @Mapping(target="updatedAt", expression="java(java.util.Date.from(TimeProvider.instantNow()))")})
    public io.gravitee.repository.management.model.flow.Flow toRepositoryUpdate(@MappingTarget io.gravitee.repository.management.model.flow.Flow var1, io.gravitee.definition.model.v4.flow.Flow var2, int var3);

    @Mappings(value={@Mapping(target="id", expression="java(UuidString.generateRandom())"), @Mapping(target="createdAt", expression="java(java.util.Date.from(TimeProvider.instantNow()))"), @Mapping(target="updatedAt", expression="java(java.util.Date.from(TimeProvider.instantNow()))")})
    public io.gravitee.repository.management.model.flow.Flow toRepository(Flow var1, FlowReferenceType var2, String var3, int var4);

    public io.gravitee.definition.model.v4.flow.Flow toFlowV4(io.gravitee.repository.management.model.flow.Flow var1);

    @Mappings(value={@Mapping(target="pathOperator.path", source="path"), @Mapping(target="pathOperator.operator", source="operator")})
    public Flow toFlowV2(io.gravitee.repository.management.model.flow.Flow var1);

    default public FlowSelector toRepository(Selector source) {
        if (source instanceof HttpSelector) {
            return this.toRepository((HttpSelector)source);
        }
        if (source instanceof ChannelSelector) {
            return this.toRepository((ChannelSelector)source);
        }
        if (source instanceof ConditionSelector) {
            return this.toRepository((ConditionSelector)source);
        }
        throw new IllegalArgumentException("Unknown selector type: " + source.getClass());
    }

    default public Selector toModel(FlowSelector source) {
        if (source instanceof FlowHttpSelector) {
            return this.toModel((FlowHttpSelector)source);
        }
        if (source instanceof FlowChannelSelector) {
            return this.toModel((FlowChannelSelector)source);
        }
        if (source instanceof FlowConditionSelector) {
            return this.toModel((FlowConditionSelector)source);
        }
        throw new IllegalArgumentException("Unknown selector type: " + source.getClass());
    }

    public FlowHttpSelector toRepository(HttpSelector var1);

    public HttpSelector toModel(FlowHttpSelector var1);

    public FlowChannelSelector toRepository(ChannelSelector var1);

    public ChannelSelector toModel(FlowChannelSelector var1);

    public FlowConditionSelector toRepository(ConditionSelector var1);

    public ConditionSelector toModel(FlowConditionSelector var1);
}

