/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.mapper;

import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.repository.management.model.Api;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.converter.ApiConverter;
import io.gravitee.rest.api.service.v4.mapper.ApiMapper;
import org.springframework.stereotype.Component;

@Component
public class GenericApiMapper {
    private final ApiMapper apiMapper;
    private final ApiConverter apiConverter;

    public GenericApiMapper(ApiMapper apiMapper, ApiConverter apiConverter) {
        this.apiMapper = apiMapper;
        this.apiConverter = apiConverter;
    }

    public GenericApiEntity toGenericApi(Api api, PrimaryOwnerEntity primaryOwner) {
        if (api.getDefinitionVersion() == DefinitionVersion.V4) {
            return this.apiMapper.toEntity(api, primaryOwner);
        }
        return this.apiConverter.toApiEntity(api, primaryOwner);
    }

    public GenericApiEntity toGenericApi(ExecutionContext executionContext, Api api, PrimaryOwnerEntity primaryOwner) {
        if (api.getDefinitionVersion() == DefinitionVersion.V4) {
            return this.apiMapper.toEntity(executionContext, api, primaryOwner, true);
        }
        return this.apiConverter.toApiEntity(executionContext, api, primaryOwner, true);
    }
}

