/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.debug.use_case;

import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.domain_service.ApiPolicyValidatorDomainService;
import io.gravitee.apim.core.api.exception.ApiNotFoundException;
import io.gravitee.apim.core.api.exception.InvalidPathsException;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.debug.exceptions.DebugApiInvalidDefinitionVersionException;
import io.gravitee.apim.core.debug.exceptions.DebugApiNoCompatibleInstanceException;
import io.gravitee.apim.core.debug.exceptions.DebugApiNoValidPlanException;
import io.gravitee.apim.core.debug.model.ApiDebugStatus;
import io.gravitee.apim.core.event.crud_service.EventCrudService;
import io.gravitee.apim.core.event.model.Event;
import io.gravitee.apim.core.gateway.model.Instance;
import io.gravitee.apim.core.gateway.query_service.InstanceQueryService;
import io.gravitee.common.util.EnvironmentUtils;
import io.gravitee.definition.model.Api;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.LoggingContent;
import io.gravitee.definition.model.LoggingMode;
import io.gravitee.definition.model.LoggingScope;
import io.gravitee.definition.model.Plan;
import io.gravitee.definition.model.debug.DebugApi;
import io.gravitee.rest.api.model.EventType;
import io.gravitee.rest.api.model.PlanStatus;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugApiUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DebugApiUseCase.class);
    private final ApiPolicyValidatorDomainService apiPolicyValidatorDomainService;
    private final ApiCrudService apiCrudService;
    private final InstanceQueryService instanceQueryService;
    private final EventCrudService eventCrudService;

    public Output execute(Input input) throws InvalidPathsException {
        log.debug("Debugging API {}", (Object)input.apiId);
        DebugApiUseCase.validateDefinitionVersion(input.apiId, input.debugApi.getDefinitionVersion());
        this.validateApiExists(input);
        this.apiPolicyValidatorDomainService.checkPolicyConfigurations((Api)input.debugApi, new HashSet<Plan>(input.debugApi.getPlans()));
        Instance selectedGateway = this.selectTargetGateway(input.auditInfo.organizationId(), input.auditInfo.environmentId(), (Api)input.debugApi);
        DebugApiUseCase.validatePlan(input.debugApi);
        DebugApiUseCase.disableLoggingForDebug(input.debugApi);
        DebugApiUseCase.disableHealthCheckForDebug(input.debugApi);
        Event debugApiEvent = this.createDebugApiEvent(input.auditInfo, input.debugApi, selectedGateway);
        return new Output(debugApiEvent);
    }

    private void validateApiExists(Input input) {
        if (!this.apiCrudService.existsById(input.apiId)) {
            throw new ApiNotFoundException(input.apiId);
        }
    }

    private Event createDebugApiEvent(AuditInfo auditInfo, DebugApi debugApi, Instance selectedInstance) {
        return this.eventCrudService.createEvent(auditInfo.organizationId(), auditInfo.environmentId(), Set.of(auditInfo.environmentId()), EventType.DEBUG_API, debugApi, Map.ofEntries(Map.entry(Event.EventProperties.USER, auditInfo.actor().userId()), Map.entry(Event.EventProperties.API_DEBUG_STATUS, ApiDebugStatus.TO_DEBUG.name()), Map.entry(Event.EventProperties.GATEWAY_ID, selectedInstance.getId()), Map.entry(Event.EventProperties.API_ID, debugApi.getId())));
    }

    private static void validateDefinitionVersion(String apiId, DefinitionVersion debugApiDefinitionVersion) {
        if (!debugApiDefinitionVersion.equals((Object)DefinitionVersion.V2)) {
            throw new DebugApiInvalidDefinitionVersionException(apiId);
        }
    }

    private static void validatePlan(DebugApi debugApi) {
        boolean hasValidPlan = debugApi.getPlans().stream().anyMatch(plan -> PlanStatus.STAGING.name().equalsIgnoreCase(plan.getStatus()) || PlanStatus.PUBLISHED.name().equalsIgnoreCase(plan.getStatus()));
        if (!hasValidPlan) {
            throw new DebugApiNoValidPlanException(debugApi.getId());
        }
    }

    private Instance selectTargetGateway(String organizationId, String environmentId, Api apiDefinition) {
        return this.instanceQueryService.findAllStarted(organizationId, environmentId).stream().filter(Instance::isClusterPrimaryNode).filter(instance -> instance.isRunningForEnvironment(environmentId)).filter(Instance::hasDebugPluginInstalled).filter(instance -> EnvironmentUtils.hasMatchingTags(Optional.ofNullable(instance.getTags()), (Set)apiDefinition.getTags())).max(Comparator.comparing(Instance::getStartedAt)).orElseThrow(() -> new DebugApiNoCompatibleInstanceException(apiDefinition.getId()));
    }

    private static void disableLoggingForDebug(DebugApi debugApi) {
        if (debugApi.getProxy() != null && debugApi.getProxy().getLogging() != null) {
            debugApi.getProxy().getLogging().setMode(LoggingMode.NONE);
            debugApi.getProxy().getLogging().setContent(LoggingContent.NONE);
            debugApi.getProxy().getLogging().setScope(LoggingScope.NONE);
        }
    }

    private static void disableHealthCheckForDebug(DebugApi debugApi) {
        if (debugApi.getServices() != null && debugApi.getServices().getHealthCheckService() != null) {
            debugApi.getServices().getHealthCheckService().setEnabled(false);
        }
    }

    @Generated
    public DebugApiUseCase(ApiPolicyValidatorDomainService apiPolicyValidatorDomainService, ApiCrudService apiCrudService, InstanceQueryService instanceQueryService, EventCrudService eventCrudService) {
        this.apiPolicyValidatorDomainService = apiPolicyValidatorDomainService;
        this.apiCrudService = apiCrudService;
        this.instanceQueryService = instanceQueryService;
        this.eventCrudService = eventCrudService;
    }

    public record Input(String apiId, DebugApi debugApi, AuditInfo auditInfo) {
        public Input {
            Objects.requireNonNull(apiId);
            Objects.requireNonNull(debugApi);
            Objects.requireNonNull(auditInfo);
        }

        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private String apiId;
            @Generated
            private DebugApi debugApi;
            @Generated
            private AuditInfo auditInfo;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder apiId(String apiId) {
                this.apiId = apiId;
                return this;
            }

            @Generated
            public InputBuilder debugApi(DebugApi debugApi) {
                this.debugApi = debugApi;
                return this;
            }

            @Generated
            public InputBuilder auditInfo(AuditInfo auditInfo) {
                this.auditInfo = auditInfo;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.apiId, this.debugApi, this.auditInfo);
            }

            @Generated
            public String toString() {
                return "DebugApiUseCase.Input.InputBuilder(apiId=" + this.apiId + ", debugApi=" + this.debugApi + ", auditInfo=" + this.auditInfo + ")";
            }
        }
    }

    public record Output(Event debugApiEvent) {
    }
}

