/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.domain_service;

import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.domain_service.ApiIndexerDomainService;
import io.gravitee.apim.core.api.domain_service.ApiMetadataDomainService;
import io.gravitee.apim.core.api.domain_service.CreateApiDomainService;
import io.gravitee.apim.core.api.domain_service.ValidateApiDomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.ApiWithFlows;
import io.gravitee.apim.core.api.model.crd.ApiCRD;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.event.ApiAuditEvent;
import io.gravitee.apim.core.flow.crud_service.FlowCrudService;
import io.gravitee.apim.core.membership.domain_service.ApiPrimaryOwnerDomainService;
import io.gravitee.apim.core.membership.domain_service.ApiPrimaryOwnerFactory;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.core.notification.crud_service.NotificationConfigCrudService;
import io.gravitee.apim.core.notification.model.config.NotificationConfig;
import io.gravitee.apim.core.parameters.model.ParameterContext;
import io.gravitee.apim.core.parameters.query_service.ParametersQueryService;
import io.gravitee.apim.core.search.Indexer;
import io.gravitee.apim.core.workflow.crud_service.WorkflowCrudService;
import io.gravitee.apim.core.workflow.model.Workflow;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import java.util.Collections;

public class CreateApiDomainServiceImpl
implements CreateApiDomainService {
    private final ValidateApiDomainService validateApiDomainService;
    private final ApiCrudService apiCrudService;
    private final AuditDomainService auditService;
    private final ApiIndexerDomainService apiIndexerDomainService;
    private final ApiPrimaryOwnerFactory apiPrimaryOwnerFactory;
    private final ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService;
    private final ApiMetadataDomainService apiMetadataDomainService;
    private final FlowCrudService flowCrudService;
    private final NotificationConfigCrudService notificationConfigCrudService;
    private final ParametersQueryService parametersQueryService;
    private final WorkflowCrudService workflowCrudService;

    public CreateApiDomainServiceImpl(ValidateApiDomainService validateApiDomainService, ApiCrudService apiCrudService, AuditDomainService auditService, ApiIndexerDomainService apiIndexerDomainService, ApiMetadataDomainService apiMetadataDomainService, ApiPrimaryOwnerFactory apiPrimaryOwnerFactory, ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService, FlowCrudService flowCrudService, NotificationConfigCrudService notificationConfigCrudService, ParametersQueryService parametersQueryService, WorkflowCrudService workflowCrudService) {
        this.validateApiDomainService = validateApiDomainService;
        this.apiCrudService = apiCrudService;
        this.auditService = auditService;
        this.apiIndexerDomainService = apiIndexerDomainService;
        this.apiPrimaryOwnerFactory = apiPrimaryOwnerFactory;
        this.apiPrimaryOwnerDomainService = apiPrimaryOwnerDomainService;
        this.apiMetadataDomainService = apiMetadataDomainService;
        this.flowCrudService = flowCrudService;
        this.notificationConfigCrudService = notificationConfigCrudService;
        this.parametersQueryService = parametersQueryService;
        this.workflowCrudService = workflowCrudService;
    }

    @Override
    public ApiWithFlows create(Api api, AuditInfo auditInfo) {
        PrimaryOwnerEntity primaryOwner = this.apiPrimaryOwnerFactory.createForNewApi(auditInfo.organizationId(), auditInfo.environmentId(), auditInfo.actor().userId());
        Api sanitized = this.validateApiDomainService.validateAndSanitizeForCreation(api, primaryOwner, auditInfo.environmentId(), auditInfo.organizationId());
        Api created = this.apiCrudService.create(sanitized);
        this.createAuditLog(created, auditInfo);
        this.apiPrimaryOwnerDomainService.createApiPrimaryOwnerMembership(created.getId(), primaryOwner, auditInfo);
        this.createDefaultMailNotification(created.getId());
        this.apiMetadataDomainService.createDefaultApiMetadata(created.getId(), auditInfo);
        this.flowCrudService.saveApiFlows(api.getId(), api.getApiDefinitionV4().getFlows());
        if (this.isApiReviewEnabled(auditInfo.organizationId(), auditInfo.environmentId())) {
            this.workflowCrudService.create(Workflow.newApiReviewWorkflow(api.getId(), auditInfo.actor().userId()));
        }
        this.apiIndexerDomainService.index(new Indexer.IndexationContext(auditInfo.organizationId(), auditInfo.environmentId()), created, primaryOwner);
        return new ApiWithFlows(created, api.getApiDefinitionV4().getFlows());
    }

    @Override
    public Api create(ApiCRD api, AuditInfo auditInfo) {
        return null;
    }

    private void createAuditLog(Api created, AuditInfo auditInfo) {
        this.auditService.createApiAuditLog(ApiAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).apiId(created.getId()).event(ApiAuditEvent.API_CREATED).actor(auditInfo.actor()).newValue(created).createdAt(created.getCreatedAt()).properties(Collections.emptyMap()).build());
    }

    private void createDefaultMailNotification(String apiId) {
        this.notificationConfigCrudService.create(NotificationConfig.defaultMailNotificationConfigFor(apiId));
    }

    private boolean isApiReviewEnabled(String organizationId, String environmentId) {
        return this.parametersQueryService.findAsBoolean(Key.API_REVIEW_ENABLED, new ParameterContext(environmentId, organizationId, ParameterReferenceType.ENVIRONMENT));
    }
}

