/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.rest.api.service.exceptions.AbstractManagementException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ForbiddenFeatureException
extends AbstractManagementException {
    private final List<String> featureNames = new ArrayList<String>();

    public ForbiddenFeatureException(String featureName) {
        this.featureNames.add(featureName);
    }

    public ForbiddenFeatureException(Collection<String> featureNames) {
        this.featureNames.addAll(featureNames);
    }

    @Override
    public int getHttpStatusCode() {
        return 403;
    }

    @Override
    public String getTechnicalCode() {
        return "feature.missing";
    }

    @Override
    public Map<String, String> getParameters() {
        return Map.of("feature", this.getFeatureNames());
    }

    @Override
    public String getMessage() {
        String featuresAsString = this.getFeatureNames();
        if (this.featureNames.size() == 1) {
            return "Feature '" + featuresAsString + "' is not available with your license tier";
        }
        return "Features [" + featuresAsString + "] are not available with your license tier";
    }

    private String getFeatureNames() {
        return String.join((CharSequence)", ", this.featureNames);
    }
}

