/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.notification.model.config.NotificationConfig;
import io.gravitee.apim.infra.adapter.NotificationConfigAdapter;
import io.gravitee.repository.management.model.GenericNotificationConfig;
import io.gravitee.repository.management.model.NotificationReferenceType;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class NotificationConfigAdapterImpl
implements NotificationConfigAdapter {
    @Override
    public NotificationConfig toEntity(GenericNotificationConfig source) {
        if (source == null) {
            return null;
        }
        NotificationConfig.NotificationConfigBuilder notificationConfig = NotificationConfig.builder();
        notificationConfig.type(this.computeType(source.getId()));
        notificationConfig.id(source.getId());
        notificationConfig.name(source.getName());
        if (source.getReferenceType() != null) {
            notificationConfig.referenceType(source.getReferenceType().name());
        }
        notificationConfig.referenceId(source.getReferenceId());
        notificationConfig.notifier(source.getNotifier());
        notificationConfig.config(source.getConfig());
        List list = source.getHooks();
        if (list != null) {
            notificationConfig.hooks(new ArrayList<String>(list));
        }
        notificationConfig.useSystemProxy(source.isUseSystemProxy());
        if (source.getCreatedAt() != null) {
            notificationConfig.createdAt(ZonedDateTime.ofInstant(source.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (source.getUpdatedAt() != null) {
            notificationConfig.updatedAt(ZonedDateTime.ofInstant(source.getUpdatedAt().toInstant(), ZoneId.systemDefault()));
        }
        return notificationConfig.build();
    }

    @Override
    public GenericNotificationConfig toRepository(NotificationConfig source) {
        if (source == null) {
            return null;
        }
        GenericNotificationConfig.GenericNotificationConfigBuilder genericNotificationConfig = GenericNotificationConfig.builder();
        genericNotificationConfig.id(source.getId());
        genericNotificationConfig.name(source.getName());
        genericNotificationConfig.notifier(source.getNotifier());
        genericNotificationConfig.config(source.getConfig());
        genericNotificationConfig.useSystemProxy(source.isUseSystemProxy());
        List<String> list = source.getHooks();
        if (list != null) {
            genericNotificationConfig.hooks(new ArrayList<String>(list));
        }
        if (source.getReferenceType() != null) {
            genericNotificationConfig.referenceType(Enum.valueOf(NotificationReferenceType.class, source.getReferenceType()));
        }
        genericNotificationConfig.referenceId(source.getReferenceId());
        if (source.getCreatedAt() != null) {
            genericNotificationConfig.createdAt(Date.from(source.getCreatedAt().toInstant()));
        }
        if (source.getUpdatedAt() != null) {
            genericNotificationConfig.updatedAt(Date.from(source.getUpdatedAt().toInstant()));
        }
        return genericNotificationConfig.build();
    }
}

