/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.license.domain_service;

import io.gravitee.apim.core.license.crud_service.LicenseCrudService;
import io.gravitee.apim.core.license.model.License;
import java.util.Objects;
import java.util.Optional;

public class LicenseDomainService {
    private final LicenseCrudService licenseCrudService;

    public LicenseDomainService(LicenseCrudService licenseCrudService) {
        this.licenseCrudService = licenseCrudService;
    }

    public Optional<License> getLicenseByOrganizationId(String organizationId) {
        return this.licenseCrudService.getOrganizationLicense(organizationId);
    }

    public void createOrUpdateOrganizationLicense(String organizationId, String license) {
        this.licenseCrudService.getOrganizationLicense(organizationId).ifPresentOrElse(l -> {
            if (!Objects.equals(l.getLicense(), license)) {
                this.licenseCrudService.updateOrganizationLicense(organizationId, license);
            }
        }, () -> {
            if (Objects.nonNull(license)) {
                this.licenseCrudService.createOrganizationLicense(organizationId, license);
            }
        });
    }
}

