/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api_key.use_case;

import io.gravitee.apim.core.api_key.domain_service.RevokeApiKeyDomainService;
import io.gravitee.apim.core.api_key.model.ApiKeyEntity;
import io.gravitee.apim.core.api_key.query_service.ApiKeyQueryService;
import io.gravitee.apim.core.application.crud_service.ApplicationCrudService;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.subscription.crud_service.SubscriptionCrudService;
import io.gravitee.apim.core.subscription.model.SubscriptionEntity;
import io.gravitee.rest.api.model.BaseApplicationEntity;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.ApiKeyNotFoundException;
import io.gravitee.rest.api.service.exceptions.InvalidApplicationApiKeyModeException;
import io.gravitee.rest.api.service.exceptions.SubscriptionNotFoundException;
import java.util.Optional;

public class RevokeApplicationSubscriptionApiKeyUseCase {
    private final SubscriptionCrudService subscriptionCrudService;
    private final ApplicationCrudService applicationCrudService;
    private final ApiKeyQueryService apiKeyQueryService;
    private final RevokeApiKeyDomainService revokeApiKeyDomainService;

    public RevokeApplicationSubscriptionApiKeyUseCase(SubscriptionCrudService subscriptionCrudService, ApplicationCrudService applicationCrudService, ApiKeyQueryService apiKeyQueryService, RevokeApiKeyDomainService revokeApiKeyDomainService) {
        this.subscriptionCrudService = subscriptionCrudService;
        this.applicationCrudService = applicationCrudService;
        this.apiKeyQueryService = apiKeyQueryService;
        this.revokeApiKeyDomainService = revokeApiKeyDomainService;
    }

    public Output execute(Input input) {
        Optional<ApiKeyEntity> apiKey = this.apiKeyQueryService.findById(input.apiKeyId());
        if (apiKey.isEmpty()) {
            throw new ApiKeyNotFoundException();
        }
        if (!apiKey.get().hasSubscription(input.subscriptionId)) {
            throw new ApiKeyNotFoundException();
        }
        SubscriptionEntity subscription = this.subscriptionCrudService.get(input.subscriptionId);
        if (!subscription.getApplicationId().equals(input.applicationId)) {
            throw new SubscriptionNotFoundException(input.subscriptionId);
        }
        BaseApplicationEntity application = this.applicationCrudService.findById(new ExecutionContext(input.auditInfo().organizationId(), input.auditInfo().environmentId()), apiKey.get().getApplicationId());
        if (application.hasApiKeySharedMode()) {
            throw new InvalidApplicationApiKeyModeException(String.format("Invalid operation for API Key mode [%s] of application [%s]", application.getApiKeyMode(), application.getId()));
        }
        return new Output(this.revokeApiKeyDomainService.revoke(apiKey.get(), input.auditInfo()));
    }

    public record Input(String apiKeyId, String applicationId, String subscriptionId, AuditInfo auditInfo) {
    }

    public record Output(ApiKeyEntity apiKey) {
    }
}

