/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.api;

import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.domain_service.UpdateApiDomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.crd.ApiCRD;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.infra.adapter.ApiAdapter;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.v4.ApiService;
import org.springframework.stereotype.Service;

@Service
public class UpdateApiDomainServiceImpl
implements UpdateApiDomainService {
    private final ApiService delegate;
    private final ApiCrudService apiCrudService;

    public UpdateApiDomainServiceImpl(ApiService delegate, ApiCrudService apiCrudService) {
        this.delegate = delegate;
        this.apiCrudService = apiCrudService;
    }

    @Override
    public Api update(String apiId, ApiCRD crd, AuditInfo auditInfo) {
        ExecutionContext executionContext = new ExecutionContext(auditInfo.organizationId(), auditInfo.environmentId());
        ApiEntity apiEntity = this.delegate.update(executionContext, apiId, ApiAdapter.INSTANCE.toUpdateApiEntity(crd), auditInfo.actor().userId());
        return this.apiCrudService.get(apiEntity.getId());
    }
}

