/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.plugin.model.PolicyPlugin;
import io.gravitee.apim.infra.adapter.PolicyPluginAdapter;
import io.gravitee.rest.api.model.v4.policy.ExecutionPhase;
import io.gravitee.rest.api.model.v4.policy.PolicyPluginEntity;
import java.util.LinkedHashSet;
import java.util.Set;

public class PolicyPluginAdapterImpl
implements PolicyPluginAdapter {
    @Override
    public PolicyPlugin map(PolicyPluginEntity source) {
        if (source == null) {
            return null;
        }
        PolicyPlugin.PolicyPluginBuilder<?, ?> policyPlugin = PolicyPlugin.builder();
        policyPlugin.id(source.getId());
        policyPlugin.name(source.getName());
        policyPlugin.description(source.getDescription());
        policyPlugin.category(source.getCategory());
        policyPlugin.version(source.getVersion());
        policyPlugin.icon(source.getIcon());
        policyPlugin.deployed(source.isDeployed());
        policyPlugin.feature(source.getFeature());
        policyPlugin.proxy(this.executionPhaseSetToExecutionPhaseSet(source.getProxy()));
        policyPlugin.message(this.executionPhaseSetToExecutionPhaseSet(source.getMessage()));
        return policyPlugin.build();
    }

    protected PolicyPlugin.ExecutionPhase executionPhaseToExecutionPhase(ExecutionPhase executionPhase) {
        if (executionPhase == null) {
            return null;
        }
        return switch (executionPhase) {
            case ExecutionPhase.REQUEST -> PolicyPlugin.ExecutionPhase.REQUEST;
            case ExecutionPhase.RESPONSE -> PolicyPlugin.ExecutionPhase.RESPONSE;
            case ExecutionPhase.MESSAGE_REQUEST -> PolicyPlugin.ExecutionPhase.MESSAGE_REQUEST;
            case ExecutionPhase.MESSAGE_RESPONSE -> PolicyPlugin.ExecutionPhase.MESSAGE_RESPONSE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + executionPhase);
        };
    }

    protected Set<PolicyPlugin.ExecutionPhase> executionPhaseSetToExecutionPhaseSet(Set<ExecutionPhase> set) {
        if (set == null) {
            return null;
        }
        LinkedHashSet<PolicyPlugin.ExecutionPhase> set1 = new LinkedHashSet<PolicyPlugin.ExecutionPhase>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (ExecutionPhase executionPhase : set) {
            set1.add(this.executionPhaseToExecutionPhase(executionPhase));
        }
        return set1;
    }
}

