/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.use_case;

import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.domain_service.ApiMetadataDomainService;
import io.gravitee.apim.core.api.domain_service.CreateApiDomainService;
import io.gravitee.apim.core.api.domain_service.DeployApiDomainService;
import io.gravitee.apim.core.api.domain_service.UpdateApiDomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.crd.ApiCRD;
import io.gravitee.apim.core.api.model.crd.ApiCRDStatus;
import io.gravitee.apim.core.api.model.crd.PlanCRD;
import io.gravitee.apim.core.api.query_service.ApiQueryService;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.plan.domain_service.CreatePlanDomainService;
import io.gravitee.apim.core.plan.domain_service.DeletePlanDomainService;
import io.gravitee.apim.core.plan.domain_service.ReorderPlanDomainService;
import io.gravitee.apim.core.plan.domain_service.UpdatePlanDomainService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.plan.query_service.PlanQueryService;
import io.gravitee.apim.core.subscription.domain_service.CloseSubscriptionDomainService;
import io.gravitee.apim.core.subscription.query_service.SubscriptionQueryService;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ImportCRDUseCase {
    private final ApiQueryService apiQueryService;
    private final CreateApiDomainService createApiDomainService;
    private final CreatePlanDomainService createPlanDomainService;
    private final ApiMetadataDomainService apiMetadataDomainService;
    private final DeployApiDomainService deployApiDomainService;
    private final UpdateApiDomainService updateApiDomainService;
    private final ApiCrudService apiCrudService;
    private final PlanQueryService planQueryService;
    private final UpdatePlanDomainService updatePlanDomainService;
    private final DeletePlanDomainService deletePlanDomainService;
    private final SubscriptionQueryService subscriptionQueryService;
    private final CloseSubscriptionDomainService closeSubscriptionDomainService;
    private final ReorderPlanDomainService reorderPlanDomainService;

    public ImportCRDUseCase(ApiCrudService apiCrudService, ApiQueryService apiQueryService, CreateApiDomainService createApiDomainService, CreatePlanDomainService createPlanDomainService, ApiMetadataDomainService apiMetadataDomainService, DeployApiDomainService deployApiDomainService, UpdateApiDomainService updateApiDomainService, PlanQueryService planQueryService, UpdatePlanDomainService updatePlanDomainService, DeletePlanDomainService deletePlanDomainService, SubscriptionQueryService subscriptionQueryService, CloseSubscriptionDomainService closeSubscriptionDomainService, ReorderPlanDomainService reorderPlanDomainService) {
        this.apiCrudService = apiCrudService;
        this.apiQueryService = apiQueryService;
        this.createApiDomainService = createApiDomainService;
        this.createPlanDomainService = createPlanDomainService;
        this.apiMetadataDomainService = apiMetadataDomainService;
        this.deployApiDomainService = deployApiDomainService;
        this.updateApiDomainService = updateApiDomainService;
        this.planQueryService = planQueryService;
        this.updatePlanDomainService = updatePlanDomainService;
        this.deletePlanDomainService = deletePlanDomainService;
        this.subscriptionQueryService = subscriptionQueryService;
        this.closeSubscriptionDomainService = closeSubscriptionDomainService;
        this.reorderPlanDomainService = reorderPlanDomainService;
    }

    public Output execute(Input input) {
        Optional<Api> api = this.apiQueryService.findByEnvironmentIdAndCrossId(input.auditInfo.environmentId(), input.crd.getCrossId());
        ApiCRDStatus status = api.map(exiting -> this.update(input, (Api)exiting)).orElseGet(() -> this.create(input));
        return new Output(status);
    }

    private ApiCRDStatus create(Input input) {
        try {
            Api api = this.createApiDomainService.create(input.crd, input.auditInfo);
            this.apiMetadataDomainService.saveApiMetadata(api.getId(), input.crd.getMetadata(), input.auditInfo);
            Map<String, String> planNameIdMapping = input.crd.getPlans().entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), this.createPlanDomainService.create(this.initPlanFromCRD((PlanCRD)entry.getValue()), ((PlanCRD)entry.getValue()).getFlows(), api, input.auditInfo).getId())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (input.crd.getDefinitionContext().getSyncFrom().equals("management")) {
                this.deployApiDomainService.deploy(api, "Import via Kubernetes operator", input.auditInfo);
            }
            return ApiCRDStatus.builder().id(api.getId()).crossId(api.getCrossId()).environmentId(input.auditInfo.environmentId()).organizationId(input.auditInfo.organizationId()).state(api.getLifecycleState().name()).plans(planNameIdMapping).build();
        }
        catch (Exception e) {
            throw new TechnicalManagementException(e);
        }
    }

    private ApiCRDStatus update(Input input, Api existingApi) {
        try {
            Api updated = this.updateApiDomainService.update(existingApi.getId(), input.crd, input.auditInfo);
            Api api = this.apiCrudService.update((Api)((Api.ApiBuilder)((Api.ApiBuilder)updated.toBuilder().definitionContext(input.crd().getDefinitionContext())).lifecycleState(Api.LifecycleState.valueOf(input.crd().getState()))).build());
            this.apiMetadataDomainService.saveApiMetadata(api.getId(), input.crd.getMetadata(), input.auditInfo);
            List<Plan> existingPlans = this.planQueryService.findAllByApiId(api.getId());
            Map<String, PlanStatus> existingPlanStatuses = existingPlans.stream().collect(Collectors.toMap(Plan::getId, Plan::getStatus));
            Map<String, String> planKeyIdMapping = input.crd().getPlans().entrySet().stream().map(entry -> {
                String key = (String)entry.getKey();
                PlanCRD plan = (PlanCRD)entry.getValue();
                if (existingPlanStatuses.containsKey(plan.getId())) {
                    return Map.entry(key, this.updatePlanDomainService.update(this.initPlanFromCRD(plan), plan.getFlows(), existingPlanStatuses, api, input.auditInfo).getId());
                }
                return Map.entry(key, this.createPlanDomainService.create(this.initPlanFromCRD(plan), plan.getFlows(), api, input.auditInfo).getId());
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            this.deletePlans(api, existingPlans, planKeyIdMapping, input);
            if (input.crd.getDefinitionContext().getSyncFrom().equals("management")) {
                this.deployApiDomainService.deploy(api, "Import via Kubernetes operator", input.auditInfo);
            }
            return ApiCRDStatus.builder().id(api.getId()).crossId(api.getCrossId()).environmentId(api.getEnvironmentId()).organizationId(input.auditInfo.organizationId()).state(api.getLifecycleState().name()).plans(planKeyIdMapping).build();
        }
        catch (Exception e) {
            throw new TechnicalManagementException(e);
        }
    }

    private void deletePlans(Api api, List<Plan> existingPlans, Map<String, String> planKeyIdMapping, Input input) {
        List<Plan> plansToDelete = existingPlans.stream().filter(plan -> !planKeyIdMapping.containsValue(plan.getId())).filter(plan -> !input.crd.getPlans().containsKey(plan.getId())).toList();
        plansToDelete.forEach(plan -> {
            this.subscriptionQueryService.findActiveSubscriptionsByPlan(plan.getId()).forEach(subscription -> this.closeSubscriptionDomainService.closeSubscription(subscription.getId(), input.auditInfo));
            this.deletePlanDomainService.delete((Plan)plan, input.auditInfo);
        });
        this.reorderPlanDomainService.refreshOrderAfterDelete(api.getId());
    }

    private Plan initPlanFromCRD(PlanCRD planCRD) {
        return ((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)Plan.builder().id(planCRD.getId())).name(planCRD.getName())).description(planCRD.getDescription())).security(planCRD.getSecurity())).characteristics(planCRD.getCharacteristics())).commentMessage(planCRD.getCommentMessage())).commentRequired(planCRD.isCommentRequired())).crossId(planCRD.getCrossId())).excludedGroups(planCRD.getExcludedGroups())).generalConditions(planCRD.getGeneralConditions())).order(planCRD.getOrder())).publishedAt(planCRD.getPublishedAt())).selectionRule(planCRD.getSelectionRule())).status(planCRD.getStatus())).tags(planCRD.getTags())).type(planCRD.getType())).validation(planCRD.getValidation())).mode(planCRD.getMode())).build();
    }

    public record Input(AuditInfo auditInfo, ApiCRD crd) {
    }

    public record Output(ApiCRDStatus status) {
    }
}

