/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.documentation.use_case;

import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.documentation.crud_service.PageCrudService;
import io.gravitee.apim.core.documentation.domain_service.ApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.model.Page;

public class ApiGetDocumentationPageUseCase {
    private final ApiDocumentationDomainService apiDocumentationDomainService;
    private final ApiCrudService apiCrudService;
    private final PageCrudService pageCrudService;

    public ApiGetDocumentationPageUseCase(ApiDocumentationDomainService apiDocumentationDomainService, ApiCrudService apiCrudService, PageCrudService pageCrudService) {
        this.apiDocumentationDomainService = apiDocumentationDomainService;
        this.apiCrudService = apiCrudService;
        this.pageCrudService = pageCrudService;
    }

    public Output execute(Input input) {
        Api api = this.apiCrudService.get(input.apiId);
        Page page = this.pageCrudService.get(input.pageId);
        this.apiDocumentationDomainService.validatePageAssociatedToApi(page, input.apiId);
        page = page.withHidden(this.apiDocumentationDomainService.pageIsHidden(page)).withGeneralConditions(this.apiDocumentationDomainService.pageIsUsedAsGeneralConditions(page, api));
        return new Output(page);
    }

    public record Input(String apiId, String pageId) {
    }

    public record Output(Page page) {
    }
}

