/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.event;

import io.gravitee.apim.core.event.model.Event;
import io.gravitee.apim.core.event.query_service.EventQueryService;
import io.gravitee.apim.infra.adapter.EventAdapter;
import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.EventRepository;
import io.gravitee.repository.management.api.search.EventCriteria;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.EventType;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.Optional;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class EventQueryServiceImpl
implements EventQueryService {
    private final EventRepository eventRepository;

    public EventQueryServiceImpl(@Lazy EventRepository eventRepository) {
        this.eventRepository = eventRepository;
    }

    @Override
    public EventQueryService.SearchResponse search(EventQueryService.SearchQuery query, Pageable pageable) {
        EventCriteria.EventCriteriaBuilder criteriaBuilder = EventCriteria.builder().environment(query.environmentId());
        query.properties().forEach((key, value) -> criteriaBuilder.property(key.getLabel(), value));
        query.types().forEach(type -> criteriaBuilder.type(EventType.valueOf((String)type.name())));
        query.id().ifPresent(id -> criteriaBuilder.property(Event.EventProperties.ID.getValue(), id));
        query.apiId().ifPresent(apiId -> criteriaBuilder.property(Event.EventProperties.API_ID.getValue(), apiId));
        query.from().ifPresent(arg_0 -> ((EventCriteria.EventCriteriaBuilder)criteriaBuilder).from(arg_0));
        query.to().ifPresent(arg_0 -> ((EventCriteria.EventCriteriaBuilder)criteriaBuilder).to(arg_0));
        Page result = this.eventRepository.search(criteriaBuilder.build(), new PageableBuilder().pageNumber(pageable.getPageNumber() - 1).pageSize(pageable.getPageSize()).build());
        return new EventQueryService.SearchResponse(result.getTotalElements(), result.getContent().stream().map(EventAdapter.INSTANCE::map).toList());
    }

    @Override
    public Optional<Event> findByIdForEnvironmentAndApi(String eventId, String environmentId, String apiId) {
        try {
            return this.eventRepository.findById((Object)eventId).map(EventAdapter.INSTANCE::map).filter(e -> e.getEnvironments().contains(environmentId) && apiId.equalsIgnoreCase(e.getProperties().get((Object)Event.EventProperties.API_ID)));
        }
        catch (TechnicalException e2) {
            throw new TechnicalManagementException("An error occurs while trying to find API event by id: " + eventId, e2);
        }
    }
}

