/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.plan.model;

import io.gravitee.apim.core.datetime.TimeProvider;
import io.gravitee.definition.model.Rule;
import io.gravitee.definition.model.v4.plan.PlanMode;
import io.gravitee.definition.model.v4.plan.PlanSecurity;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import io.gravitee.rest.api.model.v4.plan.PlanSecurityType;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class Plan
implements GenericPlanEntity {
    private String id;
    private String crossId;
    private String name;
    private String description;
    private ZonedDateTime createdAt;
    private ZonedDateTime updatedAt;
    private ZonedDateTime publishedAt;
    private ZonedDateTime closedAt;
    private Date needRedeployAt;
    private PlanValidationType validation;
    private PlanType type;
    private PlanMode mode;
    private PlanSecurity security;
    private String selectionRule;
    private Set<String> tags;
    private PlanStatus status;
    private String apiId;
    private int order;
    private List<String> characteristics;
    private List<String> excludedGroups;
    private boolean commentRequired;
    private String commentMessage;
    private String generalConditions;
    private Map<String, List<Rule>> paths;

    public io.gravitee.rest.api.model.v4.plan.PlanType getPlanType() {
        return io.gravitee.rest.api.model.v4.plan.PlanType.valueOf((String)this.type.name());
    }

    public PlanSecurity getPlanSecurity() {
        return this.security;
    }

    public PlanStatus getPlanStatus() {
        return this.status;
    }

    public io.gravitee.rest.api.model.v4.plan.PlanMode getPlanMode() {
        return io.gravitee.rest.api.model.v4.plan.PlanMode.valueOf((String)this.mode.name());
    }

    public io.gravitee.rest.api.model.v4.plan.PlanValidationType getPlanValidation() {
        return io.gravitee.rest.api.model.v4.plan.PlanValidationType.valueOf((String)this.validation.name());
    }

    public boolean isClosed() {
        return this.status == PlanStatus.CLOSED;
    }

    public boolean isDeprecated() {
        return this.status == PlanStatus.DEPRECATED;
    }

    public boolean isPublished() {
        return this.status == PlanStatus.PUBLISHED;
    }

    public Plan update(Plan updated) {
        return ((PlanBuilder)((PlanBuilder)((PlanBuilder)((PlanBuilder)((PlanBuilder)((PlanBuilder)((PlanBuilder)((PlanBuilder)((PlanBuilder)((PlanBuilder)((PlanBuilder)((PlanBuilder)((PlanBuilder)((PlanBuilder)((PlanBuilder)this.toBuilder().name(updated.name)).description(updated.description)).order(updated.order)).updatedAt(TimeProvider.now())).security(updated.security)).status(updated.status)).commentRequired(updated.commentRequired)).commentMessage(updated.commentMessage)).tags(updated.tags)).selectionRule(updated.selectionRule)).generalConditions(updated.generalConditions)).excludedGroups(updated.excludedGroups)).characteristics(updated.characteristics)).crossId(updated.crossId == null ? this.crossId : updated.crossId)).validation(updated.security != null && updated.security.getType().equals(PlanSecurityType.KEY_LESS.getLabel()) ? PlanValidationType.AUTO : updated.validation)).build();
    }

    @Generated
    private static PlanType $default$type() {
        return PlanType.API;
    }

    @Generated
    private static PlanMode $default$mode() {
        return PlanMode.STANDARD;
    }

    @Generated
    private static Set<String> $default$tags() {
        return new HashSet<String>();
    }

    @Generated
    private static List<String> $default$characteristics() {
        return new ArrayList<String>();
    }

    @Generated
    private static List<String> $default$excludedGroups() {
        return new ArrayList<String>();
    }

    @Generated
    protected Plan(PlanBuilder<?, ?> b) {
        this.id = b.id;
        this.crossId = b.crossId;
        this.name = b.name;
        this.description = b.description;
        this.createdAt = b.createdAt;
        this.updatedAt = b.updatedAt;
        this.publishedAt = b.publishedAt;
        this.closedAt = b.closedAt;
        this.needRedeployAt = b.needRedeployAt;
        this.validation = b.validation;
        this.type = b.type$set ? b.type$value : Plan.$default$type();
        this.mode = b.mode$set ? b.mode$value : Plan.$default$mode();
        this.security = b.security;
        this.selectionRule = b.selectionRule;
        this.tags = b.tags$set ? b.tags$value : Plan.$default$tags();
        this.status = b.status;
        this.apiId = b.apiId;
        this.order = b.order;
        this.characteristics = b.characteristics$set ? b.characteristics$value : Plan.$default$characteristics();
        this.excludedGroups = b.excludedGroups$set ? b.excludedGroups$value : Plan.$default$excludedGroups();
        this.commentRequired = b.commentRequired;
        this.commentMessage = b.commentMessage;
        this.generalConditions = b.generalConditions;
        this.paths = b.paths;
    }

    @Generated
    public static PlanBuilder<?, ?> builder() {
        return new PlanBuilderImpl();
    }

    @Generated
    public PlanBuilder<?, ?> toBuilder() {
        return new PlanBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getCrossId() {
        return this.crossId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public ZonedDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public ZonedDateTime getPublishedAt() {
        return this.publishedAt;
    }

    @Generated
    public ZonedDateTime getClosedAt() {
        return this.closedAt;
    }

    @Generated
    public Date getNeedRedeployAt() {
        return this.needRedeployAt;
    }

    @Generated
    public PlanValidationType getValidation() {
        return this.validation;
    }

    @Generated
    public PlanType getType() {
        return this.type;
    }

    @Generated
    public PlanMode getMode() {
        return this.mode;
    }

    @Generated
    public PlanSecurity getSecurity() {
        return this.security;
    }

    @Generated
    public String getSelectionRule() {
        return this.selectionRule;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public PlanStatus getStatus() {
        return this.status;
    }

    @Generated
    public String getApiId() {
        return this.apiId;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public List<String> getCharacteristics() {
        return this.characteristics;
    }

    @Generated
    public List<String> getExcludedGroups() {
        return this.excludedGroups;
    }

    @Generated
    public boolean isCommentRequired() {
        return this.commentRequired;
    }

    @Generated
    public String getCommentMessage() {
        return this.commentMessage;
    }

    @Generated
    public String getGeneralConditions() {
        return this.generalConditions;
    }

    @Generated
    public Map<String, List<Rule>> getPaths() {
        return this.paths;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setCrossId(String crossId) {
        this.crossId = crossId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setCreatedAt(ZonedDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(ZonedDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public void setPublishedAt(ZonedDateTime publishedAt) {
        this.publishedAt = publishedAt;
    }

    @Generated
    public void setClosedAt(ZonedDateTime closedAt) {
        this.closedAt = closedAt;
    }

    @Generated
    public void setNeedRedeployAt(Date needRedeployAt) {
        this.needRedeployAt = needRedeployAt;
    }

    @Generated
    public void setValidation(PlanValidationType validation) {
        this.validation = validation;
    }

    @Generated
    public void setType(PlanType type) {
        this.type = type;
    }

    @Generated
    public void setMode(PlanMode mode) {
        this.mode = mode;
    }

    @Generated
    public void setSecurity(PlanSecurity security) {
        this.security = security;
    }

    @Generated
    public void setSelectionRule(String selectionRule) {
        this.selectionRule = selectionRule;
    }

    @Generated
    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setStatus(PlanStatus status) {
        this.status = status;
    }

    @Generated
    public void setApiId(String apiId) {
        this.apiId = apiId;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public void setCharacteristics(List<String> characteristics) {
        this.characteristics = characteristics;
    }

    @Generated
    public void setExcludedGroups(List<String> excludedGroups) {
        this.excludedGroups = excludedGroups;
    }

    @Generated
    public void setCommentRequired(boolean commentRequired) {
        this.commentRequired = commentRequired;
    }

    @Generated
    public void setCommentMessage(String commentMessage) {
        this.commentMessage = commentMessage;
    }

    @Generated
    public void setGeneralConditions(String generalConditions) {
        this.generalConditions = generalConditions;
    }

    @Generated
    public void setPaths(Map<String, List<Rule>> paths) {
        this.paths = paths;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Plan)) {
            return false;
        }
        Plan other = (Plan)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOrder() != other.getOrder()) {
            return false;
        }
        if (this.isCommentRequired() != other.isCommentRequired()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$crossId = this.getCrossId();
        String other$crossId = other.getCrossId();
        if (this$crossId == null ? other$crossId != null : !this$crossId.equals(other$crossId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        ZonedDateTime this$createdAt = this.getCreatedAt();
        ZonedDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        ZonedDateTime this$updatedAt = this.getUpdatedAt();
        ZonedDateTime other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        ZonedDateTime this$publishedAt = this.getPublishedAt();
        ZonedDateTime other$publishedAt = other.getPublishedAt();
        if (this$publishedAt == null ? other$publishedAt != null : !((Object)this$publishedAt).equals(other$publishedAt)) {
            return false;
        }
        ZonedDateTime this$closedAt = this.getClosedAt();
        ZonedDateTime other$closedAt = other.getClosedAt();
        if (this$closedAt == null ? other$closedAt != null : !((Object)this$closedAt).equals(other$closedAt)) {
            return false;
        }
        Date this$needRedeployAt = this.getNeedRedeployAt();
        Date other$needRedeployAt = other.getNeedRedeployAt();
        if (this$needRedeployAt == null ? other$needRedeployAt != null : !((Object)this$needRedeployAt).equals(other$needRedeployAt)) {
            return false;
        }
        PlanValidationType this$validation = this.getValidation();
        PlanValidationType other$validation = other.getValidation();
        if (this$validation == null ? other$validation != null : !((Object)((Object)this$validation)).equals((Object)other$validation)) {
            return false;
        }
        PlanType this$type = this.getType();
        PlanType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        PlanMode this$mode = this.getMode();
        PlanMode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
            return false;
        }
        PlanSecurity this$security = this.getSecurity();
        PlanSecurity other$security = other.getSecurity();
        if (this$security == null ? other$security != null : !this$security.equals(other$security)) {
            return false;
        }
        String this$selectionRule = this.getSelectionRule();
        String other$selectionRule = other.getSelectionRule();
        if (this$selectionRule == null ? other$selectionRule != null : !this$selectionRule.equals(other$selectionRule)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        PlanStatus this$status = this.getStatus();
        PlanStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$apiId = this.getApiId();
        String other$apiId = other.getApiId();
        if (this$apiId == null ? other$apiId != null : !this$apiId.equals(other$apiId)) {
            return false;
        }
        List<String> this$characteristics = this.getCharacteristics();
        List<String> other$characteristics = other.getCharacteristics();
        if (this$characteristics == null ? other$characteristics != null : !((Object)this$characteristics).equals(other$characteristics)) {
            return false;
        }
        List<String> this$excludedGroups = this.getExcludedGroups();
        List<String> other$excludedGroups = other.getExcludedGroups();
        if (this$excludedGroups == null ? other$excludedGroups != null : !((Object)this$excludedGroups).equals(other$excludedGroups)) {
            return false;
        }
        String this$commentMessage = this.getCommentMessage();
        String other$commentMessage = other.getCommentMessage();
        if (this$commentMessage == null ? other$commentMessage != null : !this$commentMessage.equals(other$commentMessage)) {
            return false;
        }
        String this$generalConditions = this.getGeneralConditions();
        String other$generalConditions = other.getGeneralConditions();
        if (this$generalConditions == null ? other$generalConditions != null : !this$generalConditions.equals(other$generalConditions)) {
            return false;
        }
        Map<String, List<Rule>> this$paths = this.getPaths();
        Map<String, List<Rule>> other$paths = other.getPaths();
        return !(this$paths == null ? other$paths != null : !((Object)this$paths).equals(other$paths));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Plan;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOrder();
        result = result * 59 + (this.isCommentRequired() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $crossId = this.getCrossId();
        result = result * 59 + ($crossId == null ? 43 : $crossId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        ZonedDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        ZonedDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        ZonedDateTime $publishedAt = this.getPublishedAt();
        result = result * 59 + ($publishedAt == null ? 43 : ((Object)$publishedAt).hashCode());
        ZonedDateTime $closedAt = this.getClosedAt();
        result = result * 59 + ($closedAt == null ? 43 : ((Object)$closedAt).hashCode());
        Date $needRedeployAt = this.getNeedRedeployAt();
        result = result * 59 + ($needRedeployAt == null ? 43 : ((Object)$needRedeployAt).hashCode());
        PlanValidationType $validation = this.getValidation();
        result = result * 59 + ($validation == null ? 43 : ((Object)((Object)$validation)).hashCode());
        PlanType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        PlanMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        PlanSecurity $security = this.getSecurity();
        result = result * 59 + ($security == null ? 43 : $security.hashCode());
        String $selectionRule = this.getSelectionRule();
        result = result * 59 + ($selectionRule == null ? 43 : $selectionRule.hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        PlanStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $apiId = this.getApiId();
        result = result * 59 + ($apiId == null ? 43 : $apiId.hashCode());
        List<String> $characteristics = this.getCharacteristics();
        result = result * 59 + ($characteristics == null ? 43 : ((Object)$characteristics).hashCode());
        List<String> $excludedGroups = this.getExcludedGroups();
        result = result * 59 + ($excludedGroups == null ? 43 : ((Object)$excludedGroups).hashCode());
        String $commentMessage = this.getCommentMessage();
        result = result * 59 + ($commentMessage == null ? 43 : $commentMessage.hashCode());
        String $generalConditions = this.getGeneralConditions();
        result = result * 59 + ($generalConditions == null ? 43 : $generalConditions.hashCode());
        Map<String, List<Rule>> $paths = this.getPaths();
        result = result * 59 + ($paths == null ? 43 : ((Object)$paths).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Plan(id=" + this.getId() + ", crossId=" + this.getCrossId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", publishedAt=" + this.getPublishedAt() + ", closedAt=" + this.getClosedAt() + ", needRedeployAt=" + this.getNeedRedeployAt() + ", validation=" + this.getValidation() + ", type=" + this.getType() + ", mode=" + this.getMode() + ", security=" + this.getSecurity() + ", selectionRule=" + this.getSelectionRule() + ", tags=" + this.getTags() + ", status=" + this.getStatus() + ", apiId=" + this.getApiId() + ", order=" + this.getOrder() + ", characteristics=" + this.getCharacteristics() + ", excludedGroups=" + this.getExcludedGroups() + ", commentRequired=" + this.isCommentRequired() + ", commentMessage=" + this.getCommentMessage() + ", generalConditions=" + this.getGeneralConditions() + ", paths=" + this.getPaths() + ")";
    }

    @Generated
    public Plan() {
        this.type = Plan.$default$type();
        this.mode = Plan.$default$mode();
        this.tags = Plan.$default$tags();
        this.characteristics = Plan.$default$characteristics();
        this.excludedGroups = Plan.$default$excludedGroups();
    }

    @Generated
    public Plan(String id, String crossId, String name, String description, ZonedDateTime createdAt, ZonedDateTime updatedAt, ZonedDateTime publishedAt, ZonedDateTime closedAt, Date needRedeployAt, PlanValidationType validation, PlanType type, PlanMode mode, PlanSecurity security, String selectionRule, Set<String> tags, PlanStatus status, String apiId, int order, List<String> characteristics, List<String> excludedGroups, boolean commentRequired, String commentMessage, String generalConditions, Map<String, List<Rule>> paths) {
        this.id = id;
        this.crossId = crossId;
        this.name = name;
        this.description = description;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.publishedAt = publishedAt;
        this.closedAt = closedAt;
        this.needRedeployAt = needRedeployAt;
        this.validation = validation;
        this.type = type;
        this.mode = mode;
        this.security = security;
        this.selectionRule = selectionRule;
        this.tags = tags;
        this.status = status;
        this.apiId = apiId;
        this.order = order;
        this.characteristics = characteristics;
        this.excludedGroups = excludedGroups;
        this.commentRequired = commentRequired;
        this.commentMessage = commentMessage;
        this.generalConditions = generalConditions;
        this.paths = paths;
    }

    public static enum PlanType {
        API,
        CATALOG;

    }

    public static enum PlanValidationType {
        AUTO,
        MANUAL;

    }

    @Generated
    public static abstract class PlanBuilder<C extends Plan, B extends PlanBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private String crossId;
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private ZonedDateTime createdAt;
        @Generated
        private ZonedDateTime updatedAt;
        @Generated
        private ZonedDateTime publishedAt;
        @Generated
        private ZonedDateTime closedAt;
        @Generated
        private Date needRedeployAt;
        @Generated
        private PlanValidationType validation;
        @Generated
        private boolean type$set;
        @Generated
        private PlanType type$value;
        @Generated
        private boolean mode$set;
        @Generated
        private PlanMode mode$value;
        @Generated
        private PlanSecurity security;
        @Generated
        private String selectionRule;
        @Generated
        private boolean tags$set;
        @Generated
        private Set<String> tags$value;
        @Generated
        private PlanStatus status;
        @Generated
        private String apiId;
        @Generated
        private int order;
        @Generated
        private boolean characteristics$set;
        @Generated
        private List<String> characteristics$value;
        @Generated
        private boolean excludedGroups$set;
        @Generated
        private List<String> excludedGroups$value;
        @Generated
        private boolean commentRequired;
        @Generated
        private String commentMessage;
        @Generated
        private String generalConditions;
        @Generated
        private Map<String, List<Rule>> paths;

        @Generated
        protected B $fillValuesFrom(C instance) {
            PlanBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Plan instance, PlanBuilder<?, ?> b) {
            b.id(instance.id);
            b.crossId(instance.crossId);
            b.name(instance.name);
            b.description(instance.description);
            b.createdAt(instance.createdAt);
            b.updatedAt(instance.updatedAt);
            b.publishedAt(instance.publishedAt);
            b.closedAt(instance.closedAt);
            b.needRedeployAt(instance.needRedeployAt);
            b.validation(instance.validation);
            b.type(instance.type);
            b.mode(instance.mode);
            b.security(instance.security);
            b.selectionRule(instance.selectionRule);
            b.tags(instance.tags);
            b.status(instance.status);
            b.apiId(instance.apiId);
            b.order(instance.order);
            b.characteristics(instance.characteristics);
            b.excludedGroups(instance.excludedGroups);
            b.commentRequired(instance.commentRequired);
            b.commentMessage(instance.commentMessage);
            b.generalConditions(instance.generalConditions);
            b.paths(instance.paths);
        }

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B crossId(String crossId) {
            this.crossId = crossId;
            return this.self();
        }

        @Generated
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @Generated
        public B createdAt(ZonedDateTime createdAt) {
            this.createdAt = createdAt;
            return this.self();
        }

        @Generated
        public B updatedAt(ZonedDateTime updatedAt) {
            this.updatedAt = updatedAt;
            return this.self();
        }

        @Generated
        public B publishedAt(ZonedDateTime publishedAt) {
            this.publishedAt = publishedAt;
            return this.self();
        }

        @Generated
        public B closedAt(ZonedDateTime closedAt) {
            this.closedAt = closedAt;
            return this.self();
        }

        @Generated
        public B needRedeployAt(Date needRedeployAt) {
            this.needRedeployAt = needRedeployAt;
            return this.self();
        }

        @Generated
        public B validation(PlanValidationType validation) {
            this.validation = validation;
            return this.self();
        }

        @Generated
        public B type(PlanType type) {
            this.type$value = type;
            this.type$set = true;
            return this.self();
        }

        @Generated
        public B mode(PlanMode mode) {
            this.mode$value = mode;
            this.mode$set = true;
            return this.self();
        }

        @Generated
        public B security(PlanSecurity security) {
            this.security = security;
            return this.self();
        }

        @Generated
        public B selectionRule(String selectionRule) {
            this.selectionRule = selectionRule;
            return this.self();
        }

        @Generated
        public B tags(Set<String> tags) {
            this.tags$value = tags;
            this.tags$set = true;
            return this.self();
        }

        @Generated
        public B status(PlanStatus status) {
            this.status = status;
            return this.self();
        }

        @Generated
        public B apiId(String apiId) {
            this.apiId = apiId;
            return this.self();
        }

        @Generated
        public B order(int order) {
            this.order = order;
            return this.self();
        }

        @Generated
        public B characteristics(List<String> characteristics) {
            this.characteristics$value = characteristics;
            this.characteristics$set = true;
            return this.self();
        }

        @Generated
        public B excludedGroups(List<String> excludedGroups) {
            this.excludedGroups$value = excludedGroups;
            this.excludedGroups$set = true;
            return this.self();
        }

        @Generated
        public B commentRequired(boolean commentRequired) {
            this.commentRequired = commentRequired;
            return this.self();
        }

        @Generated
        public B commentMessage(String commentMessage) {
            this.commentMessage = commentMessage;
            return this.self();
        }

        @Generated
        public B generalConditions(String generalConditions) {
            this.generalConditions = generalConditions;
            return this.self();
        }

        @Generated
        public B paths(Map<String, List<Rule>> paths) {
            this.paths = paths;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Plan.PlanBuilder(id=" + this.id + ", crossId=" + this.crossId + ", name=" + this.name + ", description=" + this.description + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", publishedAt=" + this.publishedAt + ", closedAt=" + this.closedAt + ", needRedeployAt=" + this.needRedeployAt + ", validation=" + this.validation + ", type$value=" + this.type$value + ", mode$value=" + this.mode$value + ", security=" + this.security + ", selectionRule=" + this.selectionRule + ", tags$value=" + this.tags$value + ", status=" + this.status + ", apiId=" + this.apiId + ", order=" + this.order + ", characteristics$value=" + this.characteristics$value + ", excludedGroups$value=" + this.excludedGroups$value + ", commentRequired=" + this.commentRequired + ", commentMessage=" + this.commentMessage + ", generalConditions=" + this.generalConditions + ", paths=" + this.paths + ")";
        }
    }

    @Generated
    private static final class PlanBuilderImpl
    extends PlanBuilder<Plan, PlanBuilderImpl> {
        @Generated
        private PlanBuilderImpl() {
        }

        @Override
        @Generated
        protected PlanBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Plan build() {
            return new Plan(this);
        }
    }
}

