/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.common.event.EventManager;
import io.gravitee.common.service.AbstractService;
import io.gravitee.node.api.Node;
import io.gravitee.repository.management.model.MessageRecipient;
import io.gravitee.rest.api.model.command.CommandEntity;
import io.gravitee.rest.api.model.command.CommandQuery;
import io.gravitee.rest.api.model.command.CommandTags;
import io.gravitee.rest.api.service.CommandService;
import io.gravitee.rest.api.service.ScheduledCommandService;
import io.gravitee.rest.api.service.event.CommandEvent;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

@Component
public class ScheduledCommandsRefresherServiceImpl
extends AbstractService<ScheduledCommandsRefresherServiceImpl>
implements ScheduledCommandService<ScheduledCommandsRefresherServiceImpl>,
Runnable {
    public static final List<CommandTags> SUPPORTED_COMMAND_TAGS = Arrays.stream(CommandTags.values()).filter(commandTags -> commandTags != CommandTags.DATA_TO_INDEX).toList();
    private final CommandService commandService;
    private final Node node;
    private final TaskScheduler scheduler;
    private final String cronTrigger;
    private final EventManager eventManager;

    public ScheduledCommandsRefresherServiceImpl(CommandService commandService, Node node, @Qualifier(value="commandTaskScheduler") TaskScheduler scheduler, @Value(value="${services.commands.cron:0/5 * * * * *}") String cronTrigger, EventManager eventManager) {
        this.commandService = commandService;
        this.node = node;
        this.scheduler = scheduler;
        this.cronTrigger = cronTrigger;
        this.eventManager = eventManager;
    }

    protected String name() {
        return "Scheduled Command Service";
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.scheduler.schedule((Runnable)this, (Trigger)new CronTrigger(this.cronTrigger));
    }

    @Override
    public void run() {
        List<CommandEntity> commands = this.searchCommands();
        this.processCastMode(commands);
        commands.forEach(command -> this.eventManager.publishEvent((Enum)CommandEvent.TO_PROCESS, command));
    }

    private List<CommandEntity> searchCommands() {
        CommandQuery commandQuery = new CommandQuery();
        commandQuery.setTo(MessageRecipient.MANAGEMENT_APIS.name());
        commandQuery.setNotAckBy(this.node.id());
        commandQuery.setTags(SUPPORTED_COMMAND_TAGS);
        return this.commandService.search(commandQuery);
    }

    private void processCastMode(List<CommandEntity> commands) {
        commands.forEach(command -> {
            if (command.getTags() != null && command.getTags().size() == 1 && ((CommandTags)command.getTags().get(0)).isUnicast()) {
                this.commandService.delete(command.getId());
            } else {
                this.commandService.ack(command.getId());
            }
        });
    }
}

