/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.workflow;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.workflow.crud_service.WorkflowCrudService;
import io.gravitee.apim.core.workflow.model.Workflow;
import io.gravitee.apim.infra.adapter.WorkflowAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.WorkflowRepository;
import org.springframework.context.annotation.Lazy;

public class WorkflowCrudServiceImpl
implements WorkflowCrudService {
    private final WorkflowRepository workflowRepository;

    public WorkflowCrudServiceImpl(@Lazy WorkflowRepository metadataRepository) {
        this.workflowRepository = metadataRepository;
    }

    @Override
    public Workflow create(Workflow workflow) {
        try {
            io.gravitee.repository.management.model.Workflow result = (io.gravitee.repository.management.model.Workflow)this.workflowRepository.create((Object)WorkflowAdapter.INSTANCE.toRepository(workflow));
            return WorkflowAdapter.INSTANCE.toEntity(result);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException(String.format("An error occurs while trying to create the %s workflow of [%sId=%s]", new Object[]{workflow.getType(), workflow.getReferenceType().name().toLowerCase(), workflow.getReferenceId()}), e);
        }
    }
}

