/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.ApiMetadata;
import io.gravitee.apim.core.api.model.crd.ApiCRD;
import io.gravitee.apim.infra.adapter.ApiAdapter;
import io.gravitee.apim.infra.adapter.PlanAdapter;
import io.gravitee.common.component.Lifecycle;
import io.gravitee.definition.model.DefinitionContext;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.ResponseTemplate;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.endpointgroup.EndpointGroup;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.listener.Listener;
import io.gravitee.definition.model.v4.property.Property;
import io.gravitee.definition.model.v4.resource.Resource;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.ApiLifecycleState;
import io.gravitee.repository.management.model.LifecycleState;
import io.gravitee.rest.api.model.ApiMetadataEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.api.UpdateApiEntity;
import io.gravitee.rest.api.model.v4.api.properties.PropertyEntity;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class ApiAdapterImpl
implements ApiAdapter {
    private final PlanAdapter planAdapter = PlanAdapter.INSTANCE;

    @Override
    public Api toCoreModel(io.gravitee.repository.management.model.Api source) {
        List list;
        Set set1;
        if (source == null) {
            return null;
        }
        Api.ApiBuilder api = Api.builder();
        api.definitionContext(this.apiToDefinitionContext(source));
        api.id(source.getId());
        api.environmentId(source.getEnvironmentId());
        api.crossId(source.getCrossId());
        api.name(source.getName());
        api.description(source.getDescription());
        api.version(source.getVersion());
        api.definitionVersion(source.getDefinitionVersion());
        api.type(source.getType());
        if (source.getDeployedAt() != null) {
            api.deployedAt(ZonedDateTime.ofInstant(source.getDeployedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (source.getCreatedAt() != null) {
            api.createdAt(ZonedDateTime.ofInstant(source.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (source.getUpdatedAt() != null) {
            api.updatedAt(ZonedDateTime.ofInstant(source.getUpdatedAt().toInstant(), ZoneId.systemDefault()));
        }
        api.visibility(this.visibilityToVisibility(source.getVisibility()));
        api.lifecycleState(this.lifecycleStateToLifecycleState(source.getLifecycleState()));
        api.picture(source.getPicture());
        Set set = source.getGroups();
        if (set != null) {
            api.groups(new LinkedHashSet<String>(set));
        }
        if ((set1 = source.getCategories()) != null) {
            api.categories(new LinkedHashSet<String>(set1));
        }
        if ((list = source.getLabels()) != null) {
            api.labels(new ArrayList<String>(list));
        }
        api.disableMembershipNotifications(source.isDisableMembershipNotifications());
        api.apiLifecycleState(this.apiLifecycleStateToApiLifecycleState(source.getApiLifecycleState()));
        api.background(source.getBackground());
        api.apiDefinitionV4(this.deserializeApiDefinitionV4(source));
        api.apiDefinition(this.deserializeApiDefinitionV2(source));
        return api.build();
    }

    @Override
    public Stream<Api> toCoreModelStream(Stream<io.gravitee.repository.management.model.Api> source) {
        if (source == null) {
            return null;
        }
        return source.map(api -> this.toCoreModel((io.gravitee.repository.management.model.Api)api));
    }

    @Override
    public io.gravitee.repository.management.model.Api toRepository(Api source) {
        List<String> list;
        Set<String> set1;
        if (source == null) {
            return null;
        }
        Api.ApiBuilder api = io.gravitee.repository.management.model.Api.builder();
        api.mode(this.sourceDefinitionContextMode(source));
        api.origin(this.sourceDefinitionContextOrigin(source));
        api.id(source.getId());
        api.environmentId(source.getEnvironmentId());
        api.crossId(source.getCrossId());
        api.name(source.getName());
        api.description(source.getDescription());
        api.version(source.getVersion());
        api.definitionVersion(source.getDefinitionVersion());
        api.type(source.getType());
        if (source.getDeployedAt() != null) {
            api.deployedAt(Date.from(source.getDeployedAt().toInstant()));
        }
        if (source.getCreatedAt() != null) {
            api.createdAt(Date.from(source.getCreatedAt().toInstant()));
        }
        if (source.getUpdatedAt() != null) {
            api.updatedAt(Date.from(source.getUpdatedAt().toInstant()));
        }
        api.visibility(this.visibilityToVisibility1(source.getVisibility()));
        api.lifecycleState(this.lifecycleStateToLifecycleState1(source.getLifecycleState()));
        api.picture(source.getPicture());
        Set<String> set = source.getGroups();
        if (set != null) {
            api.groups(new LinkedHashSet<String>(set));
        }
        if ((set1 = source.getCategories()) != null) {
            api.categories(new LinkedHashSet<String>(set1));
        }
        if ((list = source.getLabels()) != null) {
            api.labels(new ArrayList<String>(list));
        }
        api.disableMembershipNotifications(source.isDisableMembershipNotifications());
        api.apiLifecycleState(this.apiLifecycleStateToApiLifecycleState1(source.getApiLifecycleState()));
        api.background(source.getBackground());
        api.definition(this.serializeApiDefinition(source));
        return api.build();
    }

    @Override
    public Stream<io.gravitee.repository.management.model.Api> toRepositoryStream(Stream<Api> source) {
        if (source == null) {
            return null;
        }
        return source.map(api -> this.toRepository((Api)api));
    }

    @Override
    public io.gravitee.definition.model.v4.Api toApiDefinition(ApiCRD source) {
        Map<String, Map<String, ResponseTemplate>> map1;
        List<Resource> list3;
        List<EndpointGroup> list1;
        List<Listener> list;
        Set<String> set;
        if (source == null) {
            return null;
        }
        Api.ApiBuilder api = io.gravitee.definition.model.v4.Api.builder();
        api.apiVersion(source.getVersion());
        api.id(source.getId());
        api.name(source.getName());
        if (source.getType() != null) {
            api.type(Enum.valueOf(ApiType.class, source.getType()));
        }
        if (source.getDefinitionVersion() != null) {
            api.definitionVersion(Enum.valueOf(DefinitionVersion.class, source.getDefinitionVersion()));
        }
        if ((set = source.getTags()) != null) {
            api.tags(new LinkedHashSet<String>(set));
        }
        if ((list = source.getListeners()) != null) {
            api.listeners(new ArrayList<Listener>(list));
        }
        if ((list1 = source.getEndpointGroups()) != null) {
            api.endpointGroups(new ArrayList<EndpointGroup>(list1));
        }
        api.analytics(source.getAnalytics());
        List<Property> list2 = source.getProperties();
        if (list2 != null) {
            api.properties(new ArrayList<Property>(list2));
        }
        if ((list3 = source.getResources()) != null) {
            api.resources(new ArrayList<Resource>(list3));
        }
        api.plans(this.planAdapter.toApiDefinition(source.getPlans()));
        List<Flow> list4 = source.getFlows();
        if (list4 != null) {
            api.flows(new ArrayList<Flow>(list4));
        }
        if ((map1 = source.getResponseTemplates()) != null) {
            api.responseTemplates(new LinkedHashMap<String, Map<String, ResponseTemplate>>(map1));
        }
        return api.build();
    }

    @Override
    public UpdateApiEntity toUpdateApiEntity(ApiCRD api) {
        Set<String> set2;
        Map<String, Map<String, ResponseTemplate>> map;
        List<EndpointGroup> list1;
        List<Listener> list;
        Set<String> set;
        if (api == null) {
            return null;
        }
        UpdateApiEntity updateApiEntity = new UpdateApiEntity();
        updateApiEntity.setApiVersion(api.getVersion());
        updateApiEntity.setName(api.getName());
        updateApiEntity.setDescription(api.getDescription());
        updateApiEntity.setId(api.getId());
        updateApiEntity.setCrossId(api.getCrossId());
        if (api.getDefinitionVersion() != null) {
            updateApiEntity.setDefinitionVersion(Enum.valueOf(DefinitionVersion.class, api.getDefinitionVersion()));
        }
        if (api.getType() != null) {
            updateApiEntity.setType(Enum.valueOf(ApiType.class, api.getType()));
        }
        if ((set = api.getTags()) != null) {
            updateApiEntity.setTags(new LinkedHashSet<String>(set));
        }
        if ((list = api.getListeners()) != null) {
            updateApiEntity.setListeners(new ArrayList<Listener>(list));
        }
        if ((list1 = api.getEndpointGroups()) != null) {
            updateApiEntity.setEndpointGroups(new ArrayList<EndpointGroup>(list1));
        }
        updateApiEntity.setAnalytics(api.getAnalytics());
        updateApiEntity.setProperties(this.propertyListToPropertyEntityList(api.getProperties()));
        List<Resource> list3 = api.getResources();
        if (list3 != null) {
            updateApiEntity.setResources(new ArrayList<Resource>(list3));
        }
        updateApiEntity.setPlans(this.planAdapter.toPlanEntityV4(api.getPlans()));
        List<Flow> list4 = api.getFlows();
        if (list4 != null) {
            updateApiEntity.setFlows(new ArrayList<Flow>(list4));
        }
        if ((map = api.getResponseTemplates()) != null) {
            updateApiEntity.setResponseTemplates(new LinkedHashMap<String, Map<String, ResponseTemplate>>(map));
        }
        if (api.getVisibility() != null) {
            updateApiEntity.setVisibility(Enum.valueOf(Visibility.class, api.getVisibility()));
        }
        if ((set2 = api.getLabels()) != null) {
            updateApiEntity.setLabels(new ArrayList<String>(set2));
        }
        updateApiEntity.setMetadata(this.apiMetadataListToApiMetadataEntityList(api.getMetadata()));
        if (api.getLifecycleState() != null) {
            updateApiEntity.setLifecycleState(Enum.valueOf(io.gravitee.rest.api.model.api.ApiLifecycleState.class, api.getLifecycleState()));
        }
        return updateApiEntity;
    }

    @Override
    public ApiEntity toApiEntity(ApiCRD api) {
        Set<String> set2;
        Map<String, Map<String, ResponseTemplate>> map;
        List<Resource> list3;
        List<EndpointGroup> list1;
        List<Listener> list;
        if (api == null) {
            return null;
        }
        ApiEntity.ApiEntityBuilder apiEntity = ApiEntity.builder();
        apiEntity.apiVersion(api.getVersion());
        apiEntity.id(api.getId());
        apiEntity.crossId(api.getCrossId());
        apiEntity.name(api.getName());
        if (api.getDefinitionVersion() != null) {
            apiEntity.definitionVersion(Enum.valueOf(DefinitionVersion.class, api.getDefinitionVersion()));
        }
        if (api.getType() != null) {
            apiEntity.type(Enum.valueOf(ApiType.class, api.getType()));
        }
        apiEntity.description(api.getDescription());
        Set<String> set = api.getTags();
        if (set != null) {
            apiEntity.tags(new LinkedHashSet<String>(set));
        }
        if ((list = api.getListeners()) != null) {
            apiEntity.listeners(new ArrayList<Listener>(list));
        }
        if ((list1 = api.getEndpointGroups()) != null) {
            apiEntity.endpointGroups(new ArrayList<EndpointGroup>(list1));
        }
        apiEntity.analytics(api.getAnalytics());
        List<Property> list2 = api.getProperties();
        if (list2 != null) {
            apiEntity.properties(new ArrayList<Property>(list2));
        }
        if ((list3 = api.getResources()) != null) {
            apiEntity.resources(new ArrayList<Resource>(list3));
        }
        apiEntity.plans(this.planAdapter.toPlanEntityV4(api.getPlans()));
        List<Flow> list4 = api.getFlows();
        if (list4 != null) {
            apiEntity.flows(new ArrayList<Flow>(list4));
        }
        if ((map = api.getResponseTemplates()) != null) {
            apiEntity.responseTemplates(new LinkedHashMap<String, Map<String, ResponseTemplate>>(map));
        }
        if (api.getVisibility() != null) {
            apiEntity.visibility(Enum.valueOf(Visibility.class, api.getVisibility()));
        }
        if (api.getState() != null) {
            apiEntity.state(Enum.valueOf(Lifecycle.State.class, api.getState()));
        }
        if ((set2 = api.getLabels()) != null) {
            apiEntity.labels(new ArrayList<String>(set2));
        }
        apiEntity.definitionContext(api.getDefinitionContext());
        if (api.getLifecycleState() != null) {
            apiEntity.lifecycleState(Enum.valueOf(io.gravitee.rest.api.model.api.ApiLifecycleState.class, api.getLifecycleState()));
        }
        return apiEntity.build();
    }

    @Override
    public Api fromApiEntity(GenericApiEntity apiEntity) {
        List list;
        Set set1;
        if (apiEntity == null) {
            return null;
        }
        Api.ApiBuilder api = Api.builder();
        api.lifecycleState(this.stateToLifecycleState(apiEntity.getState()));
        api.apiLifecycleState(this.apiLifecycleStateToApiLifecycleState2(apiEntity.getLifecycleState()));
        api.id(apiEntity.getId());
        api.name(apiEntity.getName());
        api.description(apiEntity.getDescription());
        api.definitionContext(apiEntity.getDefinitionContext());
        api.definitionVersion(apiEntity.getDefinitionVersion());
        if (apiEntity.getDeployedAt() != null) {
            api.deployedAt(ZonedDateTime.ofInstant(apiEntity.getDeployedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (apiEntity.getCreatedAt() != null) {
            api.createdAt(ZonedDateTime.ofInstant(apiEntity.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (apiEntity.getUpdatedAt() != null) {
            api.updatedAt(ZonedDateTime.ofInstant(apiEntity.getUpdatedAt().toInstant(), ZoneId.systemDefault()));
        }
        api.visibility(this.visibilityToVisibility2(apiEntity.getVisibility()));
        api.picture(apiEntity.getPicture());
        Set set = apiEntity.getGroups();
        if (set != null) {
            api.groups(new LinkedHashSet<String>(set));
        }
        if ((set1 = apiEntity.getCategories()) != null) {
            api.categories(new LinkedHashSet<String>(set1));
        }
        if ((list = apiEntity.getLabels()) != null) {
            api.labels(new ArrayList<String>(list));
        }
        api.disableMembershipNotifications(apiEntity.isDisableMembershipNotifications());
        api.background(apiEntity.getBackground());
        return api.build();
    }

    protected DefinitionContext apiToDefinitionContext(io.gravitee.repository.management.model.Api api) {
        if (api == null) {
            return null;
        }
        DefinitionContext.DefinitionContextBuilder definitionContext = DefinitionContext.builder();
        definitionContext.mode(api.getMode());
        definitionContext.origin(api.getOrigin());
        return definitionContext.build();
    }

    protected Api.Visibility visibilityToVisibility(io.gravitee.repository.management.model.Visibility visibility) {
        if (visibility == null) {
            return null;
        }
        return switch (visibility) {
            case io.gravitee.repository.management.model.Visibility.PUBLIC -> Api.Visibility.PUBLIC;
            case io.gravitee.repository.management.model.Visibility.PRIVATE -> Api.Visibility.PRIVATE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + visibility);
        };
    }

    protected Api.LifecycleState lifecycleStateToLifecycleState(LifecycleState lifecycleState) {
        if (lifecycleState == null) {
            return null;
        }
        return switch (lifecycleState) {
            case LifecycleState.STARTED -> Api.LifecycleState.STARTED;
            case LifecycleState.STOPPED -> Api.LifecycleState.STOPPED;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + lifecycleState);
        };
    }

    protected Api.ApiLifecycleState apiLifecycleStateToApiLifecycleState(ApiLifecycleState apiLifecycleState) {
        if (apiLifecycleState == null) {
            return null;
        }
        return switch (apiLifecycleState) {
            case ApiLifecycleState.CREATED -> Api.ApiLifecycleState.CREATED;
            case ApiLifecycleState.PUBLISHED -> Api.ApiLifecycleState.PUBLISHED;
            case ApiLifecycleState.UNPUBLISHED -> Api.ApiLifecycleState.UNPUBLISHED;
            case ApiLifecycleState.DEPRECATED -> Api.ApiLifecycleState.DEPRECATED;
            case ApiLifecycleState.ARCHIVED -> Api.ApiLifecycleState.ARCHIVED;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + apiLifecycleState);
        };
    }

    private String sourceDefinitionContextMode(Api api) {
        if (api == null) {
            return null;
        }
        DefinitionContext definitionContext = api.getDefinitionContext();
        if (definitionContext == null) {
            return null;
        }
        String mode = definitionContext.getMode();
        if (mode == null) {
            return null;
        }
        return mode;
    }

    private String sourceDefinitionContextOrigin(Api api) {
        if (api == null) {
            return null;
        }
        DefinitionContext definitionContext = api.getDefinitionContext();
        if (definitionContext == null) {
            return null;
        }
        String origin = definitionContext.getOrigin();
        if (origin == null) {
            return null;
        }
        return origin;
    }

    protected io.gravitee.repository.management.model.Visibility visibilityToVisibility1(Api.Visibility visibility) {
        if (visibility == null) {
            return null;
        }
        return switch (visibility) {
            case Api.Visibility.PUBLIC -> io.gravitee.repository.management.model.Visibility.PUBLIC;
            case Api.Visibility.PRIVATE -> io.gravitee.repository.management.model.Visibility.PRIVATE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + visibility);
        };
    }

    protected LifecycleState lifecycleStateToLifecycleState1(Api.LifecycleState lifecycleState) {
        if (lifecycleState == null) {
            return null;
        }
        return switch (lifecycleState) {
            case Api.LifecycleState.STARTED -> LifecycleState.STARTED;
            case Api.LifecycleState.STOPPED -> LifecycleState.STOPPED;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + lifecycleState);
        };
    }

    protected ApiLifecycleState apiLifecycleStateToApiLifecycleState1(Api.ApiLifecycleState apiLifecycleState) {
        if (apiLifecycleState == null) {
            return null;
        }
        return switch (apiLifecycleState) {
            case Api.ApiLifecycleState.CREATED -> ApiLifecycleState.CREATED;
            case Api.ApiLifecycleState.PUBLISHED -> ApiLifecycleState.PUBLISHED;
            case Api.ApiLifecycleState.UNPUBLISHED -> ApiLifecycleState.UNPUBLISHED;
            case Api.ApiLifecycleState.DEPRECATED -> ApiLifecycleState.DEPRECATED;
            case Api.ApiLifecycleState.ARCHIVED -> ApiLifecycleState.ARCHIVED;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + apiLifecycleState);
        };
    }

    protected PropertyEntity propertyToPropertyEntity(Property property) {
        if (property == null) {
            return null;
        }
        PropertyEntity.PropertyEntityBuilder propertyEntity = PropertyEntity.builder();
        propertyEntity.key(property.getKey());
        propertyEntity.value(property.getValue());
        propertyEntity.encrypted(property.isEncrypted());
        propertyEntity.dynamic(property.isDynamic());
        return propertyEntity.build();
    }

    protected List<PropertyEntity> propertyListToPropertyEntityList(List<Property> list) {
        if (list == null) {
            return null;
        }
        ArrayList<PropertyEntity> list1 = new ArrayList<PropertyEntity>(list.size());
        for (Property property : list) {
            list1.add(this.propertyToPropertyEntity(property));
        }
        return list1;
    }

    protected ApiMetadataEntity apiMetadataToApiMetadataEntity(ApiMetadata apiMetadata) {
        if (apiMetadata == null) {
            return null;
        }
        ApiMetadataEntity apiMetadataEntity = new ApiMetadataEntity();
        apiMetadataEntity.setKey(apiMetadata.getKey());
        apiMetadataEntity.setName(apiMetadata.getName());
        apiMetadataEntity.setFormat(apiMetadata.getFormat());
        apiMetadataEntity.setValue(apiMetadata.getValue());
        apiMetadataEntity.setDefaultValue(apiMetadata.getDefaultValue());
        return apiMetadataEntity;
    }

    protected List<ApiMetadataEntity> apiMetadataListToApiMetadataEntityList(List<ApiMetadata> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ApiMetadataEntity> list1 = new ArrayList<ApiMetadataEntity>(list.size());
        for (ApiMetadata apiMetadata : list) {
            list1.add(this.apiMetadataToApiMetadataEntity(apiMetadata));
        }
        return list1;
    }

    protected Api.LifecycleState stateToLifecycleState(Lifecycle.State state) {
        if (state == null) {
            return null;
        }
        return switch (state) {
            case Lifecycle.State.STOPPED -> Api.LifecycleState.STOPPED;
            case Lifecycle.State.STARTED -> Api.LifecycleState.STARTED;
            default -> null;
        };
    }

    protected Api.ApiLifecycleState apiLifecycleStateToApiLifecycleState2(io.gravitee.rest.api.model.api.ApiLifecycleState apiLifecycleState) {
        if (apiLifecycleState == null) {
            return null;
        }
        return switch (apiLifecycleState) {
            case io.gravitee.rest.api.model.api.ApiLifecycleState.CREATED -> Api.ApiLifecycleState.CREATED;
            case io.gravitee.rest.api.model.api.ApiLifecycleState.PUBLISHED -> Api.ApiLifecycleState.PUBLISHED;
            case io.gravitee.rest.api.model.api.ApiLifecycleState.UNPUBLISHED -> Api.ApiLifecycleState.UNPUBLISHED;
            case io.gravitee.rest.api.model.api.ApiLifecycleState.DEPRECATED -> Api.ApiLifecycleState.DEPRECATED;
            case io.gravitee.rest.api.model.api.ApiLifecycleState.ARCHIVED -> Api.ApiLifecycleState.ARCHIVED;
            default -> null;
        };
    }

    protected Api.Visibility visibilityToVisibility2(Visibility visibility) {
        if (visibility == null) {
            return null;
        }
        return switch (visibility) {
            case Visibility.PUBLIC -> Api.Visibility.PUBLIC;
            case Visibility.PRIVATE -> Api.Visibility.PRIVATE;
            default -> null;
        };
    }
}

