/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.documentation.domain_service;

import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.event.PageAuditEvent;
import io.gravitee.apim.core.documentation.crud_service.PageCrudService;
import io.gravitee.apim.core.documentation.crud_service.PageRevisionCrudService;
import io.gravitee.apim.core.documentation.model.Page;
import java.time.ZoneId;
import java.util.Map;

public class CreateApiDocumentationDomainService {
    private final PageCrudService pageCrudService;
    private final PageRevisionCrudService pageRevisionCrudService;
    private final AuditDomainService auditDomainService;

    public CreateApiDocumentationDomainService(PageCrudService pageCrudService, PageRevisionCrudService pageRevisionCrudService, AuditDomainService auditDomainService) {
        this.pageCrudService = pageCrudService;
        this.pageRevisionCrudService = pageRevisionCrudService;
        this.auditDomainService = auditDomainService;
    }

    public Page createPage(Page page, AuditInfo auditInfo) {
        Page createdPage = this.pageCrudService.createDocumentationPage(page);
        if (page.isMarkdown()) {
            this.pageRevisionCrudService.create(createdPage);
        }
        this.auditDomainService.createApiAuditLog(ApiAuditLogEntity.builder().apiId(page.getReferenceId()).event(PageAuditEvent.PAGE_CREATED).createdAt(page.getCreatedAt().toInstant().atZone(ZoneId.of("UTC"))).organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).actor(auditInfo.actor()).properties(Map.of(AuditProperties.PAGE, page.getId())).oldValue(null).newValue(page).build());
        return createdPage;
    }
}

