/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.flow.domain_service;

import io.gravitee.apim.core.exception.ValidationDomainException;
import io.gravitee.apim.core.flow.exception.InvalidFlowException;
import io.gravitee.apim.core.plugin.domain_service.PolicyValidationDomainService;
import io.gravitee.apim.core.plugin.model.PlatformPlugin;
import io.gravitee.apim.core.plugin.query_service.EntrypointPluginQueryService;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.flow.selector.ChannelSelector;
import io.gravitee.definition.model.v4.flow.selector.HttpSelector;
import io.gravitee.definition.model.v4.flow.selector.SelectorType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FlowValidationDomainService {
    private static final String PATH_PARAM_PREFIX = ":";
    private static final String PATH_SEPARATOR = "/";
    private static final Pattern SEPARATOR_SPLITTER = Pattern.compile("/");
    private static final Pattern PARAM_PATTERN = Pattern.compile(":\\w*");
    private final PolicyValidationDomainService policyValidationDomainService;
    private final EntrypointPluginQueryService entrypointConnectorPluginService;
    private static final Map<ApiType, Function<Flow, Optional<String>>> PATH_EXTRACTOR = Map.of(ApiType.PROXY, flow -> flow.selectorByType(SelectorType.HTTP).stream().map(selector -> ((HttpSelector)selector).getPath()).findFirst(), ApiType.MESSAGE, flow -> flow.selectorByType(SelectorType.CHANNEL).stream().map(selector -> ((ChannelSelector)selector).getChannel()).findFirst());

    public FlowValidationDomainService(PolicyValidationDomainService policyValidationDomainService, EntrypointPluginQueryService entrypointConnectorPluginService) {
        this.policyValidationDomainService = policyValidationDomainService;
        this.entrypointConnectorPluginService = entrypointConnectorPluginService;
    }

    public List<Flow> validateAndSanitize(ApiType apiType, List<Flow> flows) {
        if (flows != null) {
            flows.forEach(flow -> {
                this.checkDuplicatedSelectors((Flow)flow);
                this.checkSelectorsForType(apiType, (Flow)flow);
                this.checkPolicyConfiguration((Flow)flow);
            });
        }
        return flows;
    }

    private void checkSelectorsForType(ApiType apiType, Flow flow) {
        if (flow.getSelectors() != null) {
            if (ApiType.PROXY == apiType) {
                Set<String> invalidSelectors = flow.getSelectors().stream().filter(selector -> selector.getType() != SelectorType.HTTP && selector.getType() != SelectorType.CONDITION).map(selector -> selector.getType().getLabel()).collect(Collectors.toSet());
                if (!invalidSelectors.isEmpty()) {
                    throw InvalidFlowException.invalidSelector(flow.getName(), apiType, invalidSelectors);
                }
            } else if (ApiType.MESSAGE == apiType) {
                Set<String> invalidSelectors = flow.getSelectors().stream().filter(selector -> selector.getType() != SelectorType.CHANNEL && selector.getType() != SelectorType.CONDITION).map(selector -> selector.getType().getLabel()).collect(Collectors.toSet());
                if (!invalidSelectors.isEmpty()) {
                    throw InvalidFlowException.invalidSelector(flow.getName(), apiType, invalidSelectors);
                }
                this.checkChannelAsyncEntrypoint(flow);
            }
        }
    }

    private void checkChannelAsyncEntrypoint(Flow flow) {
        ChannelSelector channelSelector;
        Optional<ChannelSelector> channelSelectorOpt = flow.getSelectors().stream().filter(selector -> selector.getType() == SelectorType.CHANNEL).map(ChannelSelector.class::cast).findFirst();
        if (channelSelectorOpt.isPresent() && (channelSelector = channelSelectorOpt.get()).getEntrypoints() != null) {
            Set asyncEntrypoints = this.entrypointConnectorPluginService.findBySupportedApi(ApiType.MESSAGE).stream().map(PlatformPlugin::getId).collect(Collectors.toSet());
            Set<String> invalidEntrypoints = channelSelector.getEntrypoints().stream().filter(entrypointId -> !asyncEntrypoints.contains(entrypointId)).collect(Collectors.toSet());
            if (!invalidEntrypoints.isEmpty()) {
                throw InvalidFlowException.invalidEntrypoint(flow.getName(), invalidEntrypoints);
            }
        }
    }

    private void checkPolicyConfiguration(Flow flow) {
        Stream.of(flow.getRequest(), flow.getResponse(), flow.getSubscribe(), flow.getPublish()).filter(Objects::nonNull).flatMap(Collection::stream).filter(step -> step != null && step.getPolicy() != null && step.getConfiguration() != null).forEach(step -> step.setConfiguration(this.policyValidationDomainService.validateAndSanitizeConfiguration(step.getPolicy(), step.getConfiguration())));
    }

    private void checkDuplicatedSelectors(Flow flow) {
        if (flow.getSelectors() != null) {
            HashSet seenSelectors = new HashSet();
            Set<String> duplicatedSelectors = flow.getSelectors().stream().filter(e -> !seenSelectors.add(e)).map(selector -> selector.getType().getLabel()).collect(Collectors.toSet());
            if (!duplicatedSelectors.isEmpty()) {
                throw InvalidFlowException.duplicatedSelector(flow.getName(), duplicatedSelectors);
            }
        }
    }

    public void validatePathParameters(ApiType apiType, Stream<Flow> apiFlows, Stream<Flow> planFlows) {
        apiFlows = apiFlows == null ? Stream.empty() : apiFlows;
        planFlows = planFlows == null ? Stream.empty() : planFlows;
        Stream<Flow> flowsWithPathParam = this.filterFlowsWithPathParam(apiType, apiFlows, planFlows);
        this.validatePathParamOverlapping(apiType, flowsWithPathParam);
    }

    private Stream<Flow> filterFlowsWithPathParam(ApiType apiType, Stream<Flow> apiFlows, Stream<Flow> planFlows) {
        return Stream.concat(apiFlows, planFlows).filter(Flow::isEnabled).filter(flow -> FlowValidationDomainService.containsPathParam(apiType, flow));
    }

    private void validatePathParamOverlapping(ApiType apiType, Stream<Flow> flows) {
        HashMap paramWithPosition = new HashMap();
        HashMap pathsByParam = new HashMap();
        AtomicBoolean hasOverlap = new AtomicBoolean(false);
        flows.forEach(flow -> {
            String path = FlowValidationDomainService.extractPath(apiType, flow);
            String[] branches = SEPARATOR_SPLITTER.split(path);
            for (int i = 0; i < branches.length; ++i) {
                String currentBranch = branches[i];
                if (!currentBranch.startsWith(PATH_PARAM_PREFIX)) continue;
                FlowValidationDomainService.prepareOverlapsMap(pathsByParam, path, currentBranch);
                if (FlowValidationDomainService.isOverlapping(paramWithPosition, currentBranch, i)) {
                    hasOverlap.set(true);
                    continue;
                }
                paramWithPosition.put(currentBranch, i);
            }
        });
        if (hasOverlap.get()) {
            throw new ValidationDomainException("Some path parameters are used at different position across different flows.", pathsByParam.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).toString())));
        }
    }

    private static void prepareOverlapsMap(Map<String, List<String>> pathsByParam, String path, String branches) {
        pathsByParam.compute(branches, (key, value) -> {
            if (value == null) {
                value = new ArrayList<String>();
            }
            if (!value.contains(path)) {
                value.add(path);
            }
            return value;
        });
    }

    private static boolean isOverlapping(Map<String, Integer> paramWithPosition, String param, Integer i) {
        return paramWithPosition.containsKey(param) && !paramWithPosition.get(param).equals(i);
    }

    private static Boolean containsPathParam(ApiType apiType, Flow flow) {
        String path = FlowValidationDomainService.extractPath(apiType, flow);
        return PARAM_PATTERN.asPredicate().test(path);
    }

    private static String extractPath(ApiType apiType, Flow flow) {
        return PATH_EXTRACTOR.get(apiType).apply(flow).orElse("");
    }
}

