/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.initializer;

import io.gravitee.node.api.initializer.Initializer;
import io.gravitee.rest.api.model.DashboardEntity;
import io.gravitee.rest.api.model.DashboardReferenceType;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.service.DashboardService;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class DefaultDashboardsInitializer
implements Initializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultDashboardsInitializer.class);
    private final DashboardService dashboardService;
    @Lazy
    private final EnvironmentService environmentService;

    public boolean initialize() {
        List<DashboardEntity> dashboards = this.dashboardService.findAll();
        this.findAllEnvironments().stream().filter(environment -> DefaultDashboardsInitializer.shouldConfigureDashboardForEnvironment(environment, dashboards)).map(environment -> new ExecutionContext(environment.getOrganizationId(), environment.getId())).forEach(this.dashboardService::initialize);
        return true;
    }

    private Set<EnvironmentEntity> findAllEnvironments() {
        try {
            return this.environmentService.findAllOrInitialize();
        }
        catch (TechnicalManagementException e) {
            log.warn("An error occurs searching all environments.");
            return Set.of();
        }
    }

    private static boolean shouldConfigureDashboardForEnvironment(EnvironmentEntity environment, List<DashboardEntity> dashboards) {
        return dashboards.stream().noneMatch(dashboard -> dashboard.getReferenceType().equals(DashboardReferenceType.ENVIRONMENT.name()) && dashboard.getReferenceId().equals(environment.getId()));
    }

    public int getOrder() {
        return 100;
    }

    @Generated
    public DefaultDashboardsInitializer(DashboardService dashboardService, EnvironmentService environmentService) {
        this.dashboardService = dashboardService;
        this.environmentService = environmentService;
    }
}

