/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.plan.domain_service;

import io.gravitee.apim.core.documentation.crud_service.PageCrudService;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.exception.ValidationDomainException;
import io.gravitee.apim.core.parameters.model.ParameterContext;
import io.gravitee.apim.core.parameters.query_service.ParametersQueryService;
import io.gravitee.apim.core.plan.exception.PlanInvalidException;
import io.gravitee.apim.core.plan.exception.UnauthorizedPlanSecurityTypeException;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.plugin.domain_service.PolicyValidationDomainService;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.definition.model.v4.plan.PlanMode;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.v4.plan.PlanSecurityType;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanValidatorDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlanValidatorDomainService.class);
    private final ParametersQueryService parametersQueryService;
    private final PolicyValidationDomainService policyValidationDomainService;
    private final PageCrudService pageCrudService;

    public PlanValidatorDomainService(ParametersQueryService parametersQueryService, PolicyValidationDomainService policyValidationDomainService, PageCrudService pageCrudService) {
        this.parametersQueryService = parametersQueryService;
        this.policyValidationDomainService = policyValidationDomainService;
        this.pageCrudService = pageCrudService;
    }

    public void validatePlanSecurity(Plan plan, String currentOrganizationId, String currentEnvironmentId) {
        if (plan.getMode().equals((Object)PlanMode.STANDARD)) {
            this.ensurePlanSecurityIsAllowed(plan.getSecurity().getType(), currentOrganizationId, currentEnvironmentId);
            this.policyValidationDomainService.validateAndSanitizeConfiguration(plan.getSecurity().getType(), plan.getSecurity().getConfiguration());
        }
        if (plan.getMode().equals((Object)PlanMode.PUSH) && plan.getSecurity() != null) {
            throw new PlanInvalidException("Security type is forbidden for plan with 'Push' mode");
        }
    }

    public void validatePlanTagsAgainstApiTags(Set<String> planTags, Set<String> apiTags) {
        block2: {
            block3: {
                if (CollectionUtils.isEmpty(planTags)) break block2;
                if (CollectionUtils.isEmpty(apiTags)) break block3;
                if (!apiTags.stream().noneMatch(planTags::contains)) break block2;
            }
            log.debug("Plan rejected, tags {} mismatch the tags defined by the API ({})", planTags, apiTags);
            throw new ValidationDomainException("Plan tags mismatch the tags defined by the API", Map.of("planTags", String.join((CharSequence)",", planTags), "apiTags", String.join((CharSequence)",", apiTags)));
        }
    }

    public void validateGeneralConditionsPageStatus(Plan plan) {
        Optional<Page> page;
        Boolean isPublished;
        if (plan.getGeneralConditions() != null && (plan.isPublished() || plan.isDeprecated()) && !(isPublished = (page = this.pageCrudService.findById(plan.getGeneralConditions())).map(Page::isPublished).orElse(false)).booleanValue()) {
            throw new ValidationDomainException("Plan references a non published page as general conditions");
        }
    }

    private void ensurePlanSecurityIsAllowed(String securityType, String currentOrganizationId, String currentEnvironmentId) {
        Key securityKey;
        PlanSecurityType planSecurityType = PlanSecurityType.valueOfLabel((String)securityType);
        switch (planSecurityType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case API_KEY: {
                Key key = Key.PLAN_SECURITY_APIKEY_ENABLED;
                break;
            }
            case KEY_LESS: {
                Key key = Key.PLAN_SECURITY_KEYLESS_ENABLED;
                break;
            }
            case JWT: {
                Key key = Key.PLAN_SECURITY_JWT_ENABLED;
                break;
            }
            case OAUTH2: {
                Key key = securityKey = Key.PLAN_SECURITY_OAUTH2_ENABLED;
            }
        }
        if (!this.parametersQueryService.findAsBoolean(securityKey, new ParameterContext(currentEnvironmentId, currentOrganizationId, ParameterReferenceType.ENVIRONMENT))) {
            throw new UnauthorizedPlanSecurityTypeException(planSecurityType.name());
        }
    }
}

