/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.notification.internal;

import io.gravitee.apim.core.api.domain_service.ApiPrimaryOwnerDomainService;
import io.gravitee.apim.core.api.model.ApiMetadata;
import io.gravitee.apim.core.api.query_service.ApiMetadataQueryService;
import io.gravitee.apim.core.application.domain_service.ApplicationPrimaryOwnerDomainService;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.core.notification.model.ApiNotificationTemplateData;
import io.gravitee.apim.core.notification.model.ApplicationNotificationTemplateData;
import io.gravitee.apim.core.notification.model.PlanNotificationTemplateData;
import io.gravitee.apim.core.notification.model.PrimaryOwnerNotificationTemplateData;
import io.gravitee.apim.core.notification.model.SubscriptionNotificationTemplateData;
import io.gravitee.apim.core.notification.model.hook.HookContext;
import io.gravitee.apim.core.notification.model.hook.HookContextEntry;
import io.gravitee.apim.infra.template.TemplateProcessor;
import io.gravitee.apim.infra.template.TemplateProcessorException;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.ApplicationRepository;
import io.gravitee.repository.management.api.PlanRepository;
import io.gravitee.repository.management.api.SubscriptionRepository;
import io.gravitee.repository.management.model.Api;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class TemplateDataFetcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TemplateDataFetcher.class);
    private final ApiRepository apiRepository;
    private final ApplicationRepository applicationRepository;
    private final PlanRepository planRepository;
    private final SubscriptionRepository subscriptionRepository;
    private final ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService;
    private final ApplicationPrimaryOwnerDomainService applicationPrimaryOwnerDomainService;
    private final ApiMetadataQueryService metadataQueryService;
    private final TemplateProcessor templateProcessor;

    public TemplateDataFetcher(@Lazy ApiRepository apiRepository, @Lazy ApplicationRepository applicationRepository, @Lazy PlanRepository planRepository, @Lazy SubscriptionRepository subscriptionRepository, ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService, ApplicationPrimaryOwnerDomainService applicationPrimaryOwnerDomainService, ApiMetadataQueryService metadataQueryService, TemplateProcessor templateProcessor) {
        this.apiRepository = apiRepository;
        this.applicationRepository = applicationRepository;
        this.planRepository = planRepository;
        this.subscriptionRepository = subscriptionRepository;
        this.apiPrimaryOwnerDomainService = apiPrimaryOwnerDomainService;
        this.applicationPrimaryOwnerDomainService = applicationPrimaryOwnerDomainService;
        this.metadataQueryService = metadataQueryService;
        this.templateProcessor = templateProcessor;
    }

    public Map<String, Object> fetchData(String organizationId, HookContext hookContext) {
        return hookContext.getProperties().entrySet().stream().map(entry -> {
            String string = this.keyFor((HookContextEntry)((Object)((Object)entry.getKey())));
            return Map.entry(string, switch ((HookContextEntry)((Object)((Object)entry.getKey()))) {
                default -> throw new IncompatibleClassChangeError();
                case HookContextEntry.API_ID -> this.buildApiNotificationTemplateData(organizationId, (String)entry.getValue());
                case HookContextEntry.APPLICATION_ID -> this.buildApplicationNotificationTemplateData(organizationId, (String)entry.getValue());
                case HookContextEntry.PLAN_ID -> this.buildPlanNotificationTemplateData((String)entry.getValue());
                case HookContextEntry.SUBSCRIPTION_ID -> this.buildSubscriptionNotificationTemplateData((String)entry.getValue());
                case HookContextEntry.API_KEY -> Optional.of((String)entry.getValue());
            });
        }).filter(entry -> ((Optional)entry.getValue()).isPresent()).map(entry -> Map.entry((String)entry.getKey(), ((Optional)entry.getValue()).get())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private String keyFor(HookContextEntry entry) {
        return switch (entry) {
            default -> throw new IncompatibleClassChangeError();
            case HookContextEntry.API_ID -> "api";
            case HookContextEntry.APPLICATION_ID -> "application";
            case HookContextEntry.PLAN_ID -> "plan";
            case HookContextEntry.SUBSCRIPTION_ID -> "subscription";
            case HookContextEntry.API_KEY -> "apiKey";
        };
    }

    private Optional<ApiNotificationTemplateData> buildApiNotificationTemplateData(String organizationId, String apiId) {
        try {
            return this.apiRepository.findById((Object)apiId).map(api -> {
                PrimaryOwnerEntity apiPrimaryOwner = this.apiPrimaryOwnerDomainService.getApiPrimaryOwner(organizationId, apiId);
                Map<String, String> metadata = this.metadataQueryService.findApiMetadata(apiId).entrySet().stream().filter(entry -> ((ApiMetadata)entry.getValue()).getValue() != null).map(entry -> Map.entry((String)entry.getKey(), ((ApiMetadata)entry.getValue()).getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                return ApiNotificationTemplateData.builder().id(api.getId()).name(api.getName()).apiVersion(api.getVersion()).description(api.getDescription()).definitionVersion(api.getDefinitionVersion()).createdAt(api.getCreatedAt()).updatedAt(api.getUpdatedAt()).deployedAt(api.getDeployedAt()).primaryOwner(PrimaryOwnerNotificationTemplateData.from(apiPrimaryOwner)).metadata(this.decodeMetadata(metadata, (Api)api, apiPrimaryOwner)).build();
            });
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(e);
        }
    }

    private Optional<ApplicationNotificationTemplateData> buildApplicationNotificationTemplateData(String organizationId, String applicationId) {
        try {
            return this.applicationRepository.findById((Object)applicationId).map(application -> {
                PrimaryOwnerEntity primaryOwner = this.applicationPrimaryOwnerDomainService.getApplicationPrimaryOwner(organizationId, applicationId);
                return ApplicationNotificationTemplateData.builder().name(application.getName()).type(application.getType().name()).description(application.getDescription()).status(application.getStatus().name()).primaryOwner(PrimaryOwnerNotificationTemplateData.from(primaryOwner)).createdAt(application.getCreatedAt()).updatedAt(application.getUpdatedAt()).apiKeyMode(application.getApiKeyMode().name()).build();
            });
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(e);
        }
    }

    private Optional<PlanNotificationTemplateData> buildPlanNotificationTemplateData(String planId) {
        try {
            return this.planRepository.findById((Object)planId).map(plan -> PlanNotificationTemplateData.builder().id(plan.getId()).name(plan.getName()).description(plan.getDescription()).order(plan.getOrder()).createdAt(plan.getCreatedAt()).updatedAt(plan.getUpdatedAt()).publishedAt(plan.getPublishedAt()).closedAt(plan.getClosedAt()).commentMessage(plan.getCommentMessage()).security(plan.getSecurity() != null ? plan.getSecurity().name() : null).validation(plan.getValidation().name()).build());
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(e);
        }
    }

    private Optional<SubscriptionNotificationTemplateData> buildSubscriptionNotificationTemplateData(String subscriptionId) {
        try {
            return this.subscriptionRepository.findById((Object)subscriptionId).map(subscription -> SubscriptionNotificationTemplateData.builder().id(subscription.getId()).reason(subscription.getReason()).request(subscription.getRequest()).build());
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(e);
        }
    }

    private Map<String, String> decodeMetadata(Map<String, String> metadata, Api api, PrimaryOwnerEntity primaryOwner) {
        if (metadata.isEmpty()) {
            return metadata;
        }
        try {
            String decodedValue = this.templateProcessor.processInlineTemplate(metadata.toString(), Collections.singletonMap("api", ApiMetadataDecodeContext.builder().name(api.getName()).description(api.getDescription()).createdAt(api.getCreatedAt()).updatedAt(api.getUpdatedAt()).primaryOwner(new PrimaryOwnerMetadataDecodeContext(primaryOwner.id(), primaryOwner.displayName(), primaryOwner.email(), primaryOwner.type())).build()));
            return Arrays.stream(decodedValue.substring(1, decodedValue.length() - 1).split(", ")).map(entry -> entry.split("=", 2)).collect(Collectors.toMap(entry -> entry[0], entry -> ((String[])entry).length > 1 ? entry[1] : ""));
        }
        catch (TemplateProcessorException e) {
            log.warn("Error while creating template from reader:\n{}", (Object)e.getMessage());
            return metadata;
        }
        catch (Exception ex) {
            throw new TechnicalManagementException("An error occurs while evaluating API metadata", ex);
        }
    }

    public static class ApiMetadataDecodeContext {
        private String name;
        private String description;
        private Date createdAt;
        private Date updatedAt;
        private PrimaryOwnerMetadataDecodeContext primaryOwner;

        @Generated
        public static ApiMetadataDecodeContextBuilder builder() {
            return new ApiMetadataDecodeContextBuilder();
        }

        @Generated
        public ApiMetadataDecodeContext(String name, String description, Date createdAt, Date updatedAt, PrimaryOwnerMetadataDecodeContext primaryOwner) {
            this.name = name;
            this.description = description;
            this.createdAt = createdAt;
            this.updatedAt = updatedAt;
            this.primaryOwner = primaryOwner;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public Date getCreatedAt() {
            return this.createdAt;
        }

        @Generated
        public Date getUpdatedAt() {
            return this.updatedAt;
        }

        @Generated
        public PrimaryOwnerMetadataDecodeContext getPrimaryOwner() {
            return this.primaryOwner;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public void setCreatedAt(Date createdAt) {
            this.createdAt = createdAt;
        }

        @Generated
        public void setUpdatedAt(Date updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Generated
        public void setPrimaryOwner(PrimaryOwnerMetadataDecodeContext primaryOwner) {
            this.primaryOwner = primaryOwner;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApiMetadataDecodeContext)) {
                return false;
            }
            ApiMetadataDecodeContext other = (ApiMetadataDecodeContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            Date this$createdAt = this.getCreatedAt();
            Date other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
                return false;
            }
            Date this$updatedAt = this.getUpdatedAt();
            Date other$updatedAt = other.getUpdatedAt();
            if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
                return false;
            }
            PrimaryOwnerMetadataDecodeContext this$primaryOwner = this.getPrimaryOwner();
            PrimaryOwnerMetadataDecodeContext other$primaryOwner = other.getPrimaryOwner();
            return !(this$primaryOwner == null ? other$primaryOwner != null : !((Object)this$primaryOwner).equals(other$primaryOwner));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ApiMetadataDecodeContext;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            Date $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
            Date $updatedAt = this.getUpdatedAt();
            result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
            PrimaryOwnerMetadataDecodeContext $primaryOwner = this.getPrimaryOwner();
            result = result * 59 + ($primaryOwner == null ? 43 : ((Object)$primaryOwner).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TemplateDataFetcher.ApiMetadataDecodeContext(name=" + this.getName() + ", description=" + this.getDescription() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", primaryOwner=" + this.getPrimaryOwner() + ")";
        }

        @Generated
        public static class ApiMetadataDecodeContextBuilder {
            @Generated
            private String name;
            @Generated
            private String description;
            @Generated
            private Date createdAt;
            @Generated
            private Date updatedAt;
            @Generated
            private PrimaryOwnerMetadataDecodeContext primaryOwner;

            @Generated
            ApiMetadataDecodeContextBuilder() {
            }

            @Generated
            public ApiMetadataDecodeContextBuilder name(String name) {
                this.name = name;
                return this;
            }

            @Generated
            public ApiMetadataDecodeContextBuilder description(String description) {
                this.description = description;
                return this;
            }

            @Generated
            public ApiMetadataDecodeContextBuilder createdAt(Date createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            @Generated
            public ApiMetadataDecodeContextBuilder updatedAt(Date updatedAt) {
                this.updatedAt = updatedAt;
                return this;
            }

            @Generated
            public ApiMetadataDecodeContextBuilder primaryOwner(PrimaryOwnerMetadataDecodeContext primaryOwner) {
                this.primaryOwner = primaryOwner;
                return this;
            }

            @Generated
            public ApiMetadataDecodeContext build() {
                return new ApiMetadataDecodeContext(this.name, this.description, this.createdAt, this.updatedAt, this.primaryOwner);
            }

            @Generated
            public String toString() {
                return "TemplateDataFetcher.ApiMetadataDecodeContext.ApiMetadataDecodeContextBuilder(name=" + this.name + ", description=" + this.description + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", primaryOwner=" + this.primaryOwner + ")";
            }
        }
    }

    public static class PrimaryOwnerMetadataDecodeContext {
        private String id;
        private String displayName;
        private String email;
        private String type;

        @Generated
        public static PrimaryOwnerMetadataDecodeContextBuilder builder() {
            return new PrimaryOwnerMetadataDecodeContextBuilder();
        }

        @Generated
        public PrimaryOwnerMetadataDecodeContext(String id, String displayName, String email, String type) {
            this.id = id;
            this.displayName = displayName;
            this.email = email;
            this.type = type;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Generated
        public void setEmail(String email) {
            this.email = email;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PrimaryOwnerMetadataDecodeContext)) {
                return false;
            }
            PrimaryOwnerMetadataDecodeContext other = (PrimaryOwnerMetadataDecodeContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PrimaryOwnerMetadataDecodeContext;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TemplateDataFetcher.PrimaryOwnerMetadataDecodeContext(id=" + this.getId() + ", displayName=" + this.getDisplayName() + ", email=" + this.getEmail() + ", type=" + this.getType() + ")";
        }

        @Generated
        public static class PrimaryOwnerMetadataDecodeContextBuilder {
            @Generated
            private String id;
            @Generated
            private String displayName;
            @Generated
            private String email;
            @Generated
            private String type;

            @Generated
            PrimaryOwnerMetadataDecodeContextBuilder() {
            }

            @Generated
            public PrimaryOwnerMetadataDecodeContextBuilder id(String id) {
                this.id = id;
                return this;
            }

            @Generated
            public PrimaryOwnerMetadataDecodeContextBuilder displayName(String displayName) {
                this.displayName = displayName;
                return this;
            }

            @Generated
            public PrimaryOwnerMetadataDecodeContextBuilder email(String email) {
                this.email = email;
                return this;
            }

            @Generated
            public PrimaryOwnerMetadataDecodeContextBuilder type(String type) {
                this.type = type;
                return this;
            }

            @Generated
            public PrimaryOwnerMetadataDecodeContext build() {
                return new PrimaryOwnerMetadataDecodeContext(this.id, this.displayName, this.email, this.type);
            }

            @Generated
            public String toString() {
                return "TemplateDataFetcher.PrimaryOwnerMetadataDecodeContext.PrimaryOwnerMetadataDecodeContextBuilder(id=" + this.id + ", displayName=" + this.displayName + ", email=" + this.email + ", type=" + this.type + ")";
            }
        }
    }
}

