/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.api.model.crd.PlanCRD;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.infra.adapter.PlanAdapter;
import io.gravitee.definition.model.Rule;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.plan.Plan;
import io.gravitee.definition.model.v4.plan.PlanMode;
import io.gravitee.definition.model.v4.plan.PlanSecurity;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import io.gravitee.repository.management.model.Plan;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.PlanValidationType;
import io.gravitee.rest.api.model.v4.plan.NewPlanEntity;
import io.gravitee.rest.api.model.v4.plan.PlanEntity;
import io.gravitee.rest.api.model.v4.plan.PlanType;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PlanAdapterImpl
implements PlanAdapter {
    @Override
    public Plan fromRepository(io.gravitee.repository.management.model.Plan plan) {
        List list1;
        if (plan == null) {
            return null;
        }
        Plan.PlanBuilder plan1 = Plan.builder();
        plan1.apiId(plan.getApi());
        plan1.id(plan.getId());
        plan1.crossId(plan.getCrossId());
        plan1.name(plan.getName());
        plan1.description(plan.getDescription());
        if (plan.getCreatedAt() != null) {
            plan1.createdAt(ZonedDateTime.ofInstant(plan.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (plan.getUpdatedAt() != null) {
            plan1.updatedAt(ZonedDateTime.ofInstant(plan.getUpdatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (plan.getPublishedAt() != null) {
            plan1.publishedAt(ZonedDateTime.ofInstant(plan.getPublishedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (plan.getClosedAt() != null) {
            plan1.closedAt(ZonedDateTime.ofInstant(plan.getClosedAt().toInstant(), ZoneId.systemDefault()));
        }
        plan1.needRedeployAt(plan.getNeedRedeployAt());
        plan1.validation(this.planValidationTypeToPlanValidationType(plan.getValidation()));
        plan1.type(this.planTypeToPlanType(plan.getType()));
        plan1.mode(this.planModeToPlanMode(plan.getMode()));
        plan1.selectionRule(plan.getSelectionRule());
        Set set = plan.getTags();
        if (set != null) {
            plan1.tags(new LinkedHashSet<String>(set));
        }
        plan1.status(this.statusToPlanStatus(plan.getStatus()));
        plan1.order(plan.getOrder());
        List list = plan.getCharacteristics();
        if (list != null) {
            plan1.characteristics(new ArrayList<String>(list));
        }
        if ((list1 = plan.getExcludedGroups()) != null) {
            plan1.excludedGroups(new ArrayList<String>(list1));
        }
        plan1.commentRequired(plan.isCommentRequired());
        plan1.commentMessage(plan.getCommentMessage());
        plan1.generalConditions(plan.getGeneralConditions());
        plan1.security(this.computeBasePlanEntitySecurityV4(plan));
        plan1.paths(this.computeBasePlanEntityPaths(plan));
        return plan1.build();
    }

    @Override
    public io.gravitee.repository.management.model.Plan toRepository(Plan plan) {
        List<String> list1;
        List<String> list;
        if (plan == null) {
            return null;
        }
        Plan.PlanBuilder plan1 = io.gravitee.repository.management.model.Plan.builder();
        plan1.api(plan.getApiId());
        plan1.security(this.computeRepositorySecurityType(plan.getSecurity()));
        plan1.securityDefinition(this.planSecurityConfiguration(plan));
        plan1.definition(this.serializeV2PlanPaths(plan.getPaths()));
        plan1.id(plan.getId());
        plan1.crossId(plan.getCrossId());
        plan1.name(plan.getName());
        plan1.description(plan.getDescription());
        plan1.selectionRule(plan.getSelectionRule());
        plan1.validation(this.planValidationTypeToPlanValidationType1(plan.getValidation()));
        plan1.type(this.planTypeToPlanType1(plan.getType()));
        plan1.mode(this.planModeToPlanMode1(plan.getMode()));
        plan1.status(this.planStatusToStatus(plan.getStatus()));
        plan1.order(plan.getOrder());
        if (plan.getCreatedAt() != null) {
            plan1.createdAt(Date.from(plan.getCreatedAt().toInstant()));
        }
        if (plan.getUpdatedAt() != null) {
            plan1.updatedAt(Date.from(plan.getUpdatedAt().toInstant()));
        }
        if (plan.getPublishedAt() != null) {
            plan1.publishedAt(Date.from(plan.getPublishedAt().toInstant()));
        }
        if (plan.getClosedAt() != null) {
            plan1.closedAt(Date.from(plan.getClosedAt().toInstant()));
        }
        if ((list = plan.getCharacteristics()) != null) {
            plan1.characteristics(new ArrayList<String>(list));
        }
        if ((list1 = plan.getExcludedGroups()) != null) {
            plan1.excludedGroups(new ArrayList<String>(list1));
        }
        plan1.needRedeployAt(plan.getNeedRedeployAt());
        plan1.commentRequired(plan.isCommentRequired());
        plan1.commentMessage(plan.getCommentMessage());
        plan1.generalConditions(plan.getGeneralConditions());
        Set<String> set = plan.getTags();
        if (set != null) {
            plan1.tags(new LinkedHashSet<String>(set));
        }
        return plan1.build();
    }

    @Override
    public PlanEntity toEntityV4(Plan plan) {
        List<String> list1;
        if (plan == null) {
            return null;
        }
        PlanEntity.PlanEntityBuilder planEntity = PlanEntity.builder();
        planEntity.id(plan.getId());
        planEntity.crossId(plan.getCrossId());
        planEntity.name(plan.getName());
        planEntity.description(plan.getDescription());
        if (plan.getCreatedAt() != null) {
            planEntity.createdAt(Date.from(plan.getCreatedAt().toInstant()));
        }
        if (plan.getUpdatedAt() != null) {
            planEntity.updatedAt(Date.from(plan.getUpdatedAt().toInstant()));
        }
        if (plan.getPublishedAt() != null) {
            planEntity.publishedAt(Date.from(plan.getPublishedAt().toInstant()));
        }
        if (plan.getClosedAt() != null) {
            planEntity.closedAt(Date.from(plan.getClosedAt().toInstant()));
        }
        planEntity.needRedeployAt(plan.getNeedRedeployAt());
        planEntity.validation(this.planValidationTypeToPlanValidationType2(plan.getValidation()));
        planEntity.type(this.planTypeToPlanType2(plan.getType()));
        planEntity.mode(this.planModeToPlanMode2(plan.getMode()));
        planEntity.security(plan.getSecurity());
        planEntity.selectionRule(plan.getSelectionRule());
        Set<String> set = plan.getTags();
        if (set != null) {
            planEntity.tags(new LinkedHashSet<String>(set));
        }
        planEntity.status(plan.getStatus());
        planEntity.apiId(plan.getApiId());
        planEntity.order(plan.getOrder());
        List<String> list = plan.getCharacteristics();
        if (list != null) {
            planEntity.characteristics(new ArrayList<String>(list));
        }
        if ((list1 = plan.getExcludedGroups()) != null) {
            planEntity.excludedGroups(new ArrayList<String>(list1));
        }
        planEntity.commentRequired(plan.isCommentRequired());
        planEntity.commentMessage(plan.getCommentMessage());
        planEntity.generalConditions(plan.getGeneralConditions());
        return planEntity.build();
    }

    @Override
    public io.gravitee.rest.api.model.PlanEntity toEntityV2(Plan source) {
        List<String> list1;
        List<String> list;
        Map<String, List<Rule>> map;
        if (source == null) {
            return null;
        }
        PlanEntity.PlanEntityBuilder planEntity = io.gravitee.rest.api.model.PlanEntity.builder();
        planEntity.api(source.getApiId());
        planEntity.security(this.mapPlanSecurityTypeV2(source.getSecurity()));
        planEntity.securityDefinition(this.planSecurityConfiguration(source));
        planEntity.id(source.getId());
        planEntity.crossId(source.getCrossId());
        planEntity.name(source.getName());
        planEntity.description(source.getDescription());
        planEntity.validation(this.planValidationTypeToPlanValidationType3(source.getValidation()));
        planEntity.type(this.planTypeToPlanType3(source.getType()));
        planEntity.status(this.planStatusToPlanStatus(source.getStatus()));
        planEntity.order(source.getOrder());
        if (source.getCreatedAt() != null) {
            planEntity.createdAt(Date.from(source.getCreatedAt().toInstant()));
        }
        if (source.getUpdatedAt() != null) {
            planEntity.updatedAt(Date.from(source.getUpdatedAt().toInstant()));
        }
        if (source.getPublishedAt() != null) {
            planEntity.publishedAt(Date.from(source.getPublishedAt().toInstant()));
        }
        if (source.getClosedAt() != null) {
            planEntity.closedAt(Date.from(source.getClosedAt().toInstant()));
        }
        if ((map = source.getPaths()) != null) {
            planEntity.paths(new LinkedHashMap<String, List<Rule>>(map));
        }
        if ((list = source.getCharacteristics()) != null) {
            planEntity.characteristics(new ArrayList<String>(list));
        }
        if ((list1 = source.getExcludedGroups()) != null) {
            planEntity.excludedGroups(new ArrayList<String>(list1));
        }
        planEntity.needRedeployAt(source.getNeedRedeployAt());
        planEntity.commentRequired(source.isCommentRequired());
        planEntity.commentMessage(source.getCommentMessage());
        planEntity.generalConditions(source.getGeneralConditions());
        Set<String> set = source.getTags();
        if (set != null) {
            planEntity.tags(new LinkedHashSet<String>(set));
        }
        planEntity.selectionRule(source.getSelectionRule());
        return planEntity.build();
    }

    @Override
    public NewPlanEntity entityToNewPlanEntity(PlanEntity entity) {
        List list2;
        List list1;
        if (entity == null) {
            return null;
        }
        NewPlanEntity newPlanEntity = new NewPlanEntity();
        newPlanEntity.setName(entity.getName());
        newPlanEntity.setDescription(entity.getDescription());
        newPlanEntity.setId(entity.getId());
        newPlanEntity.setCrossId(entity.getCrossId());
        newPlanEntity.setApiId(entity.getApiId());
        newPlanEntity.setValidation(entity.getValidation());
        newPlanEntity.setSecurity(entity.getSecurity());
        newPlanEntity.setType(entity.getType());
        newPlanEntity.setMode(entity.getMode());
        newPlanEntity.setStatus(entity.getStatus());
        List list = entity.getFlows();
        if (list != null) {
            newPlanEntity.setFlows(new ArrayList(list));
        }
        if ((list1 = entity.getCharacteristics()) != null) {
            newPlanEntity.setCharacteristics(new ArrayList(list1));
        }
        if ((list2 = entity.getExcludedGroups()) != null) {
            newPlanEntity.setExcludedGroups(new ArrayList(list2));
        }
        newPlanEntity.setCommentRequired(entity.isCommentRequired());
        newPlanEntity.setCommentMessage(entity.getCommentMessage());
        Set set = entity.getTags();
        if (set != null) {
            newPlanEntity.setTags(new LinkedHashSet(set));
        }
        newPlanEntity.setSelectionRule(entity.getSelectionRule());
        newPlanEntity.setGeneralConditions(entity.getGeneralConditions());
        newPlanEntity.setOrder(entity.getOrder());
        return newPlanEntity;
    }

    @Override
    public PlanCRD toCRD(Plan source) {
        if (source == null) {
            return null;
        }
        PlanCRD.PlanCRDBuilder planCRD = PlanCRD.builder();
        planCRD.id(source.getId());
        planCRD.name(source.getName());
        planCRD.description(source.getDescription());
        planCRD.security(source.getSecurity());
        List<String> list = source.getCharacteristics();
        if (list != null) {
            planCRD.characteristics(new ArrayList<String>(list));
        }
        planCRD.commentMessage(source.getCommentMessage());
        planCRD.commentRequired(source.isCommentRequired());
        planCRD.crossId(source.getCrossId());
        List<String> list1 = source.getExcludedGroups();
        if (list1 != null) {
            planCRD.excludedGroups(new ArrayList<String>(list1));
        }
        planCRD.generalConditions(source.getGeneralConditions());
        planCRD.order(source.getOrder());
        planCRD.publishedAt(source.getPublishedAt());
        planCRD.selectionRule(source.getSelectionRule());
        planCRD.status(source.getStatus());
        Set<String> set = source.getTags();
        if (set != null) {
            planCRD.tags(new LinkedHashSet<String>(set));
        }
        planCRD.type(source.getType());
        planCRD.validation(source.getValidation());
        planCRD.mode(source.getMode());
        return planCRD.build();
    }

    @Override
    public PlanEntity toEntityV4(PlanCRD source) {
        List<String> list1;
        if (source == null) {
            return null;
        }
        PlanEntity.PlanEntityBuilder planEntity = PlanEntity.builder();
        planEntity.id(source.getId());
        planEntity.crossId(source.getCrossId());
        planEntity.name(source.getName());
        planEntity.description(source.getDescription());
        if (source.getPublishedAt() != null) {
            planEntity.publishedAt(Date.from(source.getPublishedAt().toInstant()));
        }
        planEntity.validation(this.planValidationTypeToPlanValidationType2(source.getValidation()));
        planEntity.type(this.planTypeToPlanType2(source.getType()));
        planEntity.mode(this.planModeToPlanMode2(source.getMode()));
        planEntity.security(source.getSecurity());
        planEntity.selectionRule(source.getSelectionRule());
        Set<String> set = source.getTags();
        if (set != null) {
            planEntity.tags(new LinkedHashSet<String>(set));
        }
        planEntity.status(source.getStatus());
        planEntity.order(source.getOrder());
        List<String> list = source.getCharacteristics();
        if (list != null) {
            planEntity.characteristics(new ArrayList<String>(list));
        }
        if ((list1 = source.getExcludedGroups()) != null) {
            planEntity.excludedGroups(new ArrayList<String>(list1));
        }
        planEntity.commentRequired(source.isCommentRequired());
        planEntity.commentMessage(source.getCommentMessage());
        planEntity.generalConditions(source.getGeneralConditions());
        List<Flow> list2 = source.getFlows();
        if (list2 != null) {
            planEntity.flows(new ArrayList<Flow>(list2));
        }
        return planEntity.build();
    }

    @Override
    public io.gravitee.definition.model.v4.plan.Plan toApiDefinition(PlanCRD source) {
        Set<String> set;
        if (source == null) {
            return null;
        }
        Plan.PlanBuilder plan = io.gravitee.definition.model.v4.plan.Plan.builder();
        plan.id(source.getId());
        plan.name(source.getName());
        plan.security(source.getSecurity());
        plan.mode(source.getMode());
        plan.selectionRule(source.getSelectionRule());
        List<Flow> list = source.getFlows();
        if (list != null) {
            plan.flows(new ArrayList<Flow>(list));
        }
        if ((set = source.getTags()) != null) {
            plan.tags(new LinkedHashSet<String>(set));
        }
        plan.status(source.getStatus());
        return plan.build();
    }

    protected Plan.PlanValidationType planValidationTypeToPlanValidationType(Plan.PlanValidationType planValidationType) {
        if (planValidationType == null) {
            return null;
        }
        return switch (planValidationType) {
            case Plan.PlanValidationType.AUTO -> Plan.PlanValidationType.AUTO;
            case Plan.PlanValidationType.MANUAL -> Plan.PlanValidationType.MANUAL;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + planValidationType);
        };
    }

    protected Plan.PlanType planTypeToPlanType(Plan.PlanType planType) {
        if (planType == null) {
            return null;
        }
        return switch (planType) {
            case Plan.PlanType.API -> Plan.PlanType.API;
            case Plan.PlanType.CATALOG -> Plan.PlanType.CATALOG;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + planType);
        };
    }

    protected PlanMode planModeToPlanMode(Plan.PlanMode planMode) {
        if (planMode == null) {
            return null;
        }
        return switch (planMode) {
            case Plan.PlanMode.STANDARD -> PlanMode.STANDARD;
            case Plan.PlanMode.PUSH -> PlanMode.PUSH;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + planMode);
        };
    }

    protected PlanStatus statusToPlanStatus(Plan.Status status) {
        if (status == null) {
            return null;
        }
        return switch (status) {
            case Plan.Status.STAGING -> PlanStatus.STAGING;
            case Plan.Status.PUBLISHED -> PlanStatus.PUBLISHED;
            case Plan.Status.CLOSED -> PlanStatus.CLOSED;
            case Plan.Status.DEPRECATED -> PlanStatus.DEPRECATED;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + status);
        };
    }

    private String planSecurityConfiguration(Plan plan) {
        if (plan == null) {
            return null;
        }
        PlanSecurity security = plan.getSecurity();
        if (security == null) {
            return null;
        }
        String configuration = security.getConfiguration();
        if (configuration == null) {
            return null;
        }
        return configuration;
    }

    protected Plan.PlanValidationType planValidationTypeToPlanValidationType1(Plan.PlanValidationType planValidationType) {
        if (planValidationType == null) {
            return null;
        }
        return switch (planValidationType) {
            case Plan.PlanValidationType.AUTO -> Plan.PlanValidationType.AUTO;
            case Plan.PlanValidationType.MANUAL -> Plan.PlanValidationType.MANUAL;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + planValidationType);
        };
    }

    protected Plan.PlanType planTypeToPlanType1(Plan.PlanType planType) {
        if (planType == null) {
            return null;
        }
        return switch (planType) {
            case Plan.PlanType.API -> Plan.PlanType.API;
            case Plan.PlanType.CATALOG -> Plan.PlanType.CATALOG;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + planType);
        };
    }

    protected Plan.PlanMode planModeToPlanMode1(PlanMode planMode) {
        if (planMode == null) {
            return null;
        }
        return switch (planMode) {
            case PlanMode.STANDARD -> Plan.PlanMode.STANDARD;
            case PlanMode.PUSH -> Plan.PlanMode.PUSH;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + planMode);
        };
    }

    protected Plan.Status planStatusToStatus(PlanStatus planStatus) {
        if (planStatus == null) {
            return null;
        }
        return switch (planStatus) {
            case PlanStatus.STAGING -> Plan.Status.STAGING;
            case PlanStatus.PUBLISHED -> Plan.Status.PUBLISHED;
            case PlanStatus.DEPRECATED -> Plan.Status.DEPRECATED;
            case PlanStatus.CLOSED -> Plan.Status.CLOSED;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + planStatus);
        };
    }

    protected io.gravitee.rest.api.model.v4.plan.PlanValidationType planValidationTypeToPlanValidationType2(Plan.PlanValidationType planValidationType) {
        if (planValidationType == null) {
            return null;
        }
        return switch (planValidationType) {
            case Plan.PlanValidationType.AUTO -> io.gravitee.rest.api.model.v4.plan.PlanValidationType.AUTO;
            case Plan.PlanValidationType.MANUAL -> io.gravitee.rest.api.model.v4.plan.PlanValidationType.MANUAL;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + planValidationType);
        };
    }

    protected PlanType planTypeToPlanType2(Plan.PlanType planType) {
        if (planType == null) {
            return null;
        }
        return switch (planType) {
            case Plan.PlanType.API -> PlanType.API;
            case Plan.PlanType.CATALOG -> PlanType.CATALOG;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + planType);
        };
    }

    protected io.gravitee.rest.api.model.v4.plan.PlanMode planModeToPlanMode2(PlanMode planMode) {
        if (planMode == null) {
            return null;
        }
        return switch (planMode) {
            case PlanMode.STANDARD -> io.gravitee.rest.api.model.v4.plan.PlanMode.STANDARD;
            case PlanMode.PUSH -> io.gravitee.rest.api.model.v4.plan.PlanMode.PUSH;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + planMode);
        };
    }

    protected PlanValidationType planValidationTypeToPlanValidationType3(Plan.PlanValidationType planValidationType) {
        if (planValidationType == null) {
            return null;
        }
        return switch (planValidationType) {
            case Plan.PlanValidationType.AUTO -> PlanValidationType.AUTO;
            case Plan.PlanValidationType.MANUAL -> PlanValidationType.MANUAL;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + planValidationType);
        };
    }

    protected io.gravitee.rest.api.model.PlanType planTypeToPlanType3(Plan.PlanType planType) {
        if (planType == null) {
            return null;
        }
        return switch (planType) {
            case Plan.PlanType.API -> io.gravitee.rest.api.model.PlanType.API;
            case Plan.PlanType.CATALOG -> io.gravitee.rest.api.model.PlanType.CATALOG;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + planType);
        };
    }

    protected io.gravitee.rest.api.model.PlanStatus planStatusToPlanStatus(PlanStatus planStatus) {
        if (planStatus == null) {
            return null;
        }
        return switch (planStatus) {
            case PlanStatus.STAGING -> io.gravitee.rest.api.model.PlanStatus.STAGING;
            case PlanStatus.PUBLISHED -> io.gravitee.rest.api.model.PlanStatus.PUBLISHED;
            case PlanStatus.DEPRECATED -> io.gravitee.rest.api.model.PlanStatus.DEPRECATED;
            case PlanStatus.CLOSED -> io.gravitee.rest.api.model.PlanStatus.CLOSED;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + planStatus);
        };
    }
}

