/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.rest.api.service.exceptions.AbstractNotFoundException;
import java.util.Map;

public class ApiMediaNotFoundException
extends AbstractNotFoundException {
    private final String hash;
    private final String apiId;

    public ApiMediaNotFoundException(String hash, String apiId) {
        this.hash = hash;
        this.apiId = apiId;
    }

    @Override
    public String getMessage() {
        return String.format("No media with hash [%s] could be found for API [%s]", this.hash, this.apiId);
    }

    @Override
    public String getTechnicalCode() {
        return "apiMedia.notFound";
    }

    @Override
    public Map<String, String> getParameters() {
        return Map.of("hash", this.hash, "api", this.apiId);
    }
}

